import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Image;
//import java.awt.image.BufferedImage;
import java.awt.Event;
import java.awt.AWTEvent;
import java.awt.event.ComponentEvent;
import java.awt.Frame;
import java.awt.Font;
import java.awt.PopupMenu;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.awt.event.KeyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.ComponentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;
import java.net.URL;
import java.io.StreamTokenizer;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.awt.MediaTracker;
/**
 *	l'applette principale
 */
public class GeoPlanJ extends Applet
    implements Runnable, MouseListener, MouseMotionListener, ActionListener, KeyListener, ComponentListener, FocusListener {
    public static final boolean DEBUG = false;
    Thread fred;
    int h, m, s, ms;
    int nbCadres = 0;// nombre de cadres dans la figure
    //Image offscreen, offscreenAffichage, offscreenTrace;
    //Graphics offgraph, offgraphAffichage, offgraphTrace;
    Image fond;
    int longueur = 100, largeur = 100, hauteur = 100;
    int largeurDuFond = 0;
    int hauteurDuFond = 0;
    GeoPlanJFigure figure;
    Color couleurDeFond;
    GeoPlanJPhrases gpPhrases;	//pour etudier les phrases
    int sourisx, sourisy, sourisbouton, compteclick;
    boolean barreDesAffichagesAttrappee = false;
    boolean etudeDeLaFigureEnCours = false;
    //Font font;
    PopupMenu popup;
    GeoPlanJObjet grabObjet = null;
    Frame fdialog = new Frame();		//un frame pour les boites de dialogues
    String[] texteDeLaFigure= {};
    String[] texteParDefaut = {
	"Figure Goplan",
	"Numro de version: 2",
	"Position de Roxy: Xmin: -5, Xmax: 5, Ymax: 5",
	"Objet dessinable Roxy, particularits: rouge, dessin",
	"Commentaire",
	"Fin de la figure"
    };
    StreamTokenizer st;
    Reader r;
    MediaTracker tracker;
    //GeoPlanJNombre time;
    //GeoPlanJObjet dernier;
    String tagEnCours;// ceci permet de distinguer les commentaires ou les prototypes, entre autres...
    String commentaires = "";
    boolean visible = false;
    boolean exportation = true;
    boolean importation = true;
    int focus = 0;//1 si focus
    public void init() {
	//System.out.println(getCodeBase() + getParameter("fichier"));
	String nomDuFichier = getParameter("fichier");
	//System.out.println("/" + nomDuFichier + "/");
	if(nomDuFichier != null) {
	    //System.out.println("fichier");
	    chargerFigure(nomDuFichier);
	} else {
	    //System.out.println("pas de fichier");
	    String tempTexte = getParameter("textedelafigure");
	    if(tempTexte != null) {
		for(int i = 0 ; i < 25 ; i++) {
		    System.out.println(tempTexte.charAt(i));
		}
		StringTokenizer st = new StringTokenizer(tempTexte, "_\n\r\f");
		while (st.hasMoreTokens()) {
		    //System.out.println(st.nextToken());
		    //texteSols = texteSols.concat(st.nextToken());
		    String temp = st.nextToken();
		    if(!"".equals(temp)) {
			String[] tempTexteDeLaFigure = new String[texteDeLaFigure.length+1];
			System.arraycopy(texteDeLaFigure, 0, tempTexteDeLaFigure, 0, texteDeLaFigure.length);
			texteDeLaFigure = tempTexteDeLaFigure;
			texteDeLaFigure[texteDeLaFigure.length-1] = temp;
		    }
		}
	    } else {
		//System.out.println("pas de texte de figure");
		texteDeLaFigure = texteParDefaut;
	    }
	}
	/*  
	    for(int i = 0 ; i < texteDeLaFigure.length ; i++) {
	    System.out.println(i + " : <" +texteDeLaFigure[i] + ">");
	    }
	*/
	String tempTexte = getParameter("couleurDuFond");
	//System.out.println("la couleur du fond est : " + tempTexte);
	if(tempTexte == null) {
	    tempTexte = getParameter("BackColor");
	    //System.out.println("la \"BackColor\" est : " + tempTexte);
	    if(tempTexte == null) {
		couleurDeFond = Color.white;// couleur blanc par dfaut
	    } else {
		try{
		    couleurDeFond = new Color((new Integer(tempTexte)).intValue());
		} catch(Exception e) {
		    System.out.println("le paramtre \"BackColor\" n'est pas correct");
		    couleurDeFond = Color.white;
		}
	    }
	} else {
	    couleurDeFond = figure.couleurNommee(tempTexte);
	    if(couleurDeFond == null) {
		couleurDeFond = Color.white;// couleur blanc par dfaut
	    }
	}
        setBackground(couleurDeFond);
	etudeDeLaFigureEnCours = true;
	executeTexteDeLaFigure();
	etudeDeLaFigureEnCours = false;
	if(!"Figure finie".equals(tagEnCours)) {
	    System.out.println("il y a eu une erreur dans l'tude de la figure");
	    figure.offgraph[0].clearRect(0, 0, largeur, hauteur);
	    repaint();// il y a eu une erreur, tout est arrt, mais il faut l'afficher
	}
        //System.out.println("PARAM fond : " + getCodeBase() + getParameter("fond"));
        tracker = new MediaTracker(this);
	tempTexte = getParameter("fond");
	if(tempTexte == null) {
	    fond = null;
	} else {
	    fond = getImage(getCodeBase(), tempTexte);
	    tracker.addImage(fond, 0);
	}
	/*********************************************************
	 * on termine les inits par les "Listeners" et le menu
	 *********************************************************/
	addMouseListener(this);
        addMouseMotionListener(this);
        addKeyListener(this);
        addComponentListener(this);
	addFocusListener(this);
        popup = new PopupMenu();
        GeoPlanJMenuSurgissant crepopup = new GeoPlanJMenuSurgissant(popup, this);
        add(popup);
    }
    public void chargerFigure(String nomDuFichier) {
	System.out.println(getCodeBase() + nomDuFichier);
	//System.out.println(getDocumentBase() + nomDuFichier);
	texteDeLaFigure = new String[0];
	try{
	    InputStreamReader is = new InputStreamReader(new URL(getCodeBase(), nomDuFichier).openStream(), "8859_1");
	    System.out.println("le fichier de la figure est ouvert");
	    //r = new BufferedReader(is);
	    System.out.println(is.getEncoding());
	    st = new StreamTokenizer(new BufferedReader(is));
	    st.eolIsSignificant(false);
	    st.wordChars(32, 175);//on prend tous les caracteres ASCII
	    //  modifier pour les caractres spciaux (Unicode)
	    while(st.nextToken() != StreamTokenizer.TT_EOF) {
		if(st.ttype == StreamTokenizer.TT_WORD) {
		    //System.out.println(st.sval);
		    String[] tempTexteDeLaFigure = new String[texteDeLaFigure.length+1];
		    System.arraycopy(texteDeLaFigure, 0, tempTexteDeLaFigure, 0, texteDeLaFigure.length);
		    texteDeLaFigure = tempTexteDeLaFigure;
		    texteDeLaFigure[texteDeLaFigure.length-1] = st.sval;
		} else {
		    System.out.println("ce n'est pas un mot");
		    System.out.println(st.ttype);
		}
	    }
	} catch(Exception e) {
	    System.out.println("Erreur pendant le chargement de la figure : " + e.getMessage());
	    System.out.println("                                          : " + e.toString());
	    //System.exit(-1);
	}
    }
    public void destroy() {
        //removeComponentListener(this);
        //removeKeyListener(this);
        //removeMouseMotionListener(this);
        //removeMouseListener(this);
    }
    public void run() {
	/* il faut trouver mieux pour charger les images
        try {
            tracker.waitForAll();//on commence  charger les images
        } catch (Exception e) {
	    System.out.println(e.getMessage());
	}
	*/
	while(true) {
            try {
                Thread.sleep(10);//10 ms (?)
            }
            catch (Exception e) {
		System.out.println(e.getMessage());
            }
	    figure.time.valeur = (double)System.currentTimeMillis()/1000;
	    // ici le comportement diffre lgrement de GeoplanW car time reprsente le nombre de seconde depuis le 1er janvier 1970, alors que dans GeoPlanW, c'est le temps depuis le dbut de la journe
	    repaint();
	}
	/*
	Thread me = Thread.currentThread();
	while(fred == me) {
            try {
                Thread.currentThread().sleep(10);//10 ms (?)
            }
            catch (Exception e) {
		System.out.println(e.getMessage());
            }
	    figure.time.valeur = (double)System.currentTimeMillis()/1000;
	    // ici le comportement diffre lgrement de GeoplanW car time reprsente le nombre de seconde depuis le 1er janvier 1970, alors que dans GeoPlanW, c'est le temps depuis le dbut de la journe
	    repaint();
	}
	*/
    }
    public void start() {
        fred = new Thread(this);
        fred.start();
    }
    public void stop() {
        fred = null;
    }
    public void focusGained(FocusEvent e) {
	focus = 1;
    }
    public void focusLost(FocusEvent e) {
	focus = 0;
    }
    public  void mouseClicked(MouseEvent e) {
        sourisx = e.getX();
        sourisy = e.getY();
        compteclick = e.getClickCount();
        sourisbouton = e.getModifiers();
	//elimination provisoire (?) du popup menu
        if ((compteclick > 1)&&(sourisbouton == MouseEvent.BUTTON1_MASK)) {
	    //System.out.println("bouton 1 click");
	    popup.show(this, sourisx, sourisy);
	}
	//
    }
    public  void mousePressed(MouseEvent e) {
        requestFocus();
	stop();
        //if (e.getClickCount() == 1) {
	sourisx = e.getX();
	sourisy = e.getY();
	sourisbouton = e.getModifiers();
	if (sourisbouton == MouseEvent.BUTTON3_MASK || e.isMetaDown()) {
	    if(sourisy >= figure.hauteurDesAffichages) {
		grabObjet = figure.roxy;
		//System.out.println("Roxy attrap");
	    }
	} else {    	//if (sourisbouton == MouseEvent.BUTTON1_MASK) {
	    if(sourisy < figure.hauteurDesAffichages && sourisy > figure.hauteurDesAffichages - 4) {
		//System.out.println("barreDesAffichages attrape");
		barreDesAffichagesAttrappee = true;
		sourisy = figure.hauteurDesAffichages;
	    } else {
		grabObjet = figure.chercheLibre(sourisx, sourisy);// - figure.hauteurDesAffichages);
		// on doit soustraire hauteurDesAffichages pour tenir compte de la zone des affichages
		/*
		if(grabObjet == null) {
		    //System.out.println("rien attrap");
		} else {
		    //System.out.println("Objet " + grabObjet.nom + " attrap");
		}
		// et on cherche s'il y a un objet libre  moins de 2 pixels.
		*/
	    }
	}
    }
    public  void mouseReleased(MouseEvent e) {
        grabObjet = null;
	barreDesAffichagesAttrappee = false;
	//System.out.println("hauteurDesAffichages = " + figure.hauteurDesAffichages);
	start();
    }
    public  void mouseEntered(MouseEvent e) {
    }
    public  void mouseExited(MouseEvent e) {
	//la ligne suivante permet de faire lacher les objets lorsque la souris sort
	//du cadre de la figure. Mais ce comportement est bizarre...
        //grabObjet = null;
    }
    public  void mouseDragged(MouseEvent e) {
	int tempx = e.getX();
	int tempy = e.getY();
        if (grabObjet != null) {
	    if (grabObjet.type == GeoPlanJObjet.Repere && figure.traceActive == 0) {// ce cas ne peut se produire que pour roxy
		double dx = ((double) (tempx - sourisx));
		double dy = ((double) (tempy - sourisy));
		sourisx = tempx;
		sourisy = tempy;
		((GeoPlanJNombre)figure.o.antecedents[0]).valeur += dx;// on modifie en consequence
		((GeoPlanJNombre)figure.o.antecedents[1]).valeur += dy;// les coordonnees de l'origine
		figure.Xmin -= dx / figure.uoxy.valeur;
		figure.Xmax -= dx / figure.uoxy.valeur;
		figure.Ymax += dy / figure.uoxy.valeur;
		figure.o.miseAJour();
		figure.vecJ.suivant.miseAJour();
		figure.vecJ.suivant.suivant.miseAJour();
		figure.roxy.miseAJour();
		repaint();
	    } else if (grabObjet.type == GeoPlanJObjet.Point) {
		((GeoPlanJPoint)grabObjet).nouvellesCoords(tempx, tempy);// - figure.hauteurDesAffichages);
		// on doit soustraire hauteurDesAffichages pour tenir compte de la zone des affichages
		repaint();
	    }
        } else if(barreDesAffichagesAttrappee) {
	    //System.out.println("barreDesAffichages bouge");
	    /*
	    figure.hauteurDesAffichages += tempy - sourisy;
	    sourisy = tempy;
	    if(figure.hauteurDesAffichages < 4) {
		sourisy += 4 - figure.hauteurDesAffichages;
		figure.hauteurDesAffichages = 4;
	    } else if(figure.hauteurDesAffichages > hauteur/2) {
		sourisy += (int)(hauteur/2) - figure.hauteurDesAffichages;
		figure.hauteurDesAffichages = (int)(hauteur/2);
	    }
	    */
	    figure.hauteurDesAffichages = tempy;
	    if(figure.hauteurDesAffichages < 4) {
		figure.hauteurDesAffichages = 4;
	    } else if(figure.hauteurDesAffichages > (int)(hauteur/2)) {
		figure.hauteurDesAffichages = (int)(hauteur/2);
	    }
	    //((GeoPlanJNombre)figure.o.antecedents[1]).valeur -= (double)figure.hauteurDesAffichages - sourisy;
	    sourisy = figure.hauteurDesAffichages;
	    //mettreLesEcransAJour();
	    repaint();
	}
    }
    public  void mouseMoved(MouseEvent e) {
    }
    /**
     *	on traite les touches qui ne gnrent pas d'venements keyTyped
     */
    public void keyPressed(KeyEvent e) {
	//System.out.println("venement clavier : " + e.getKeyText(e.getKeyCode()));
        switch(e.getKeyCode()) {
	case KeyEvent.VK_LEFT:
            //System.out.println("clavier : gauche");
	    if(figure.objetLibreActifAuClavier != null) {
		if(figure.objetLibreActifAuClavier.type == GeoPlanJObjet.Point) {
		    ((GeoPlanJPoint)figure.objetLibreActifAuClavier).nouvellesCoords((int)(((GeoPlanJPoint)figure.objetLibreActifAuClavier).x - 5 + 0.5), (int)(((GeoPlanJPoint)figure.objetLibreActifAuClavier).y + 0.5));// provisoire
		} else if(figure.objetLibreActifAuClavier.type == GeoPlanJObjet.Nombre) {
		    ((GeoPlanJNombre)figure.objetLibreActifAuClavier).valeur -= 1;// provisoire
		}
	    }
	    repaint();
            break;
	case KeyEvent.VK_RIGHT:
            //System.out.println("clavier : droite");
	    if(figure.objetLibreActifAuClavier != null) {
		if(figure.objetLibreActifAuClavier.type == GeoPlanJObjet.Point) {
		    ((GeoPlanJPoint)figure.objetLibreActifAuClavier).nouvellesCoords((int)(((GeoPlanJPoint)figure.objetLibreActifAuClavier).x + 5 + 0.5), (int)(((GeoPlanJPoint)figure.objetLibreActifAuClavier).y + 0.5));// provisoire
		} else if(figure.objetLibreActifAuClavier.type == GeoPlanJObjet.Nombre) {
		    ((GeoPlanJNombre)figure.objetLibreActifAuClavier).valeur += 1;// provisoire
		}
	    }
	    repaint();
            break;
	case KeyEvent.VK_UP:
            //System.out.println("clavier : haut");
	    if(figure.objetLibreActifAuClavier != null) {
		if(figure.objetLibreActifAuClavier.type == GeoPlanJObjet.Point) {
		    ((GeoPlanJPoint)figure.objetLibreActifAuClavier).nouvellesCoords((int)(((GeoPlanJPoint)figure.objetLibreActifAuClavier).x + 0.5), (int)(((GeoPlanJPoint)figure.objetLibreActifAuClavier).y - 5 + 0.5));// provisoire
		} else if(figure.objetLibreActifAuClavier.type == GeoPlanJObjet.Nombre) {
		    ((GeoPlanJNombre)figure.objetLibreActifAuClavier).valeur += 1;// provisoire
		}
	    }
	    repaint();
            break;
	case KeyEvent.VK_DOWN:
            //System.out.println("clavier : bas");
	    if(figure.objetLibreActifAuClavier != null) {
		if(figure.objetLibreActifAuClavier.type == GeoPlanJObjet.Point) {
		    ((GeoPlanJPoint)figure.objetLibreActifAuClavier).nouvellesCoords((int)(((GeoPlanJPoint)figure.objetLibreActifAuClavier).x + 0.5), (int)(((GeoPlanJPoint)figure.objetLibreActifAuClavier).y + 5 + 0.5));// provisoire
		} else if(figure.objetLibreActifAuClavier.type == GeoPlanJObjet.Nombre) {
		    //System.out.println("nombre actif " + figure.objetLibreActifAuClavier.nom + " : " + Double.toString(((GeoPlanJNombre)figure.objetLibreActifAuClavier).valeur));
		    ((GeoPlanJNombre)figure.objetLibreActifAuClavier).valeur -= 1;// provisoire
		    //System.out.println("nombre actif " + figure.objetLibreActifAuClavier.nom + " : " + Double.toString(((GeoPlanJNombre)figure.objetLibreActifAuClavier).valeur));
		}
	    }
	    repaint();
            break;
        }
    }
    public void keyReleased(KeyEvent e) {
    }
    /**
     *	venement clavier des touches normales
     */
    public void keyTyped(KeyEvent e) {
	//System.out.println("venement clavier : " + e.getKeyChar());
	switch(e.getKeyChar()) {
	case '<':
	case 'a':
	    //System.out.println("clavier : <");
	    if(figure.traceActive == 0) {
		figure.zoomIn();
	    }
	    break;
	case '>':
	case 'z':
	    //System.out.println("clavier : >");
	    if(figure.traceActive == 0) {
		figure.zoomOut();
	    }
	    break;
	    //		case :
	    //			break;
	case 't':
	    if(figure.traceActive == 1) {
		figure.traceActive = 0;
		refaitImageDuFond();
		//figure.offgraph[2].clearRect(0, 0, largeur, hauteur);
		//figure.offgraph[2] = figure.offgraph[0];
	    } else {
		figure.traceActive = 1;
		//refaitImageDuFond();
		//figure.offgraph[2] = figure.offscreen[2].getGraphics();// pour les traces
		//figure.offgraph[2].clearRect(0, 0, largeur, hauteur);
	    }
	    break;
	case 'l':
	    System.out.println("figure principale :");
	    GeoPlanJObjet temp = figure.time;
	    while(temp != null) {
		if(temp.HS) {
		    System.out.print("**HS** ");
		}
		if(temp.type == GeoPlanJObjet.Point) {
		    System.out.println(temp.nom + " : x = " + ((GeoPlanJPoint)temp).x + ", y = " + ((GeoPlanJPoint)temp).y);
		} else if(temp.type == GeoPlanJObjet.Repere) {
		    System.out.println(temp.nom + " :");
		    System.out.println(((GeoPlanJRepere)temp).ax + " " + ((GeoPlanJRepere)temp).bx + " " + ((GeoPlanJRepere)temp).cx);
		    System.out.println(((GeoPlanJRepere)temp).ay + " " + ((GeoPlanJRepere)temp).by + " " + ((GeoPlanJRepere)temp).cy);
		} else if(temp.type == GeoPlanJObjet.Cercle) {
		    System.out.println("cercle " + temp.nom + " de centre (" + Double.toString(((GeoPlanJCercle)temp).x) + ", " + Double.toString(((GeoPlanJCercle)temp).y) + "), R = " + ((GeoPlanJCercle)temp).R);
		} else if(temp.type == GeoPlanJObjet.Point) {
		    System.out.println("point " + temp.nom + " : " + ((GeoPlanJPoint)temp).x + ", " + ((GeoPlanJPoint)temp).y);
		} else if(temp.type == GeoPlanJObjet.Vecteur) {
		    System.out.println("vecteur " + temp.nom + " : " + ((GeoPlanJVecteur)temp).x + ", " + ((GeoPlanJVecteur)temp).y);
		} else if(temp.type == GeoPlanJObjet.Nombre) {
		    System.out.println("nombre " + temp.nom + " : " + ((GeoPlanJNombre)temp).valeur);
		} else {
		    System.out.println(temp.nom);
		}
		temp = temp.suivant;
	    }
	    for(int i = 0 ; i < figure.prototypes.length ; i++) {
		System.out.println("prototype" + Integer.toString(i) + " : ");
		temp = figure.prototypes[i];
		while(temp != null) {
		    if(temp.HS) {
			System.out.print("**HS** ");
		    }
		    if(temp.type == GeoPlanJObjet.Point) {
			System.out.println(temp.nom + " : x = " + ((GeoPlanJPoint)temp).x + ", y = " + ((GeoPlanJPoint)temp).y);
		    } else if(temp.type == GeoPlanJObjet.Repere) {
			System.out.println(temp.nom + " :");
			System.out.println(((GeoPlanJRepere)temp).ax + " " + ((GeoPlanJRepere)temp).bx + " " + ((GeoPlanJRepere)temp).cx);
			System.out.println(((GeoPlanJRepere)temp).ay + " " + ((GeoPlanJRepere)temp).by + " " + ((GeoPlanJRepere)temp).cy);
		    } else if(temp.type == GeoPlanJObjet.Cercle) {
			System.out.println("cercle " + temp.nom + " de centre (" + Double.toString(((GeoPlanJCercle)temp).x) + ", " + Double.toString(((GeoPlanJCercle)temp).y) + "), R = " + ((GeoPlanJCercle)temp).R);
		    } else if(temp.type == GeoPlanJObjet.Point) {
			System.out.println("point " + temp.nom + " : " + ((GeoPlanJPoint)temp).x + ", " + ((GeoPlanJPoint)temp).y);
		    } else if(temp.type == GeoPlanJObjet.Vecteur) {
			System.out.println("vecteur " + temp.nom + " : " + ((GeoPlanJVecteur)temp).x + ", " + ((GeoPlanJVecteur)temp).y);
		    } else if(temp.type == GeoPlanJObjet.Nombre) {
			System.out.println("nombre " + temp.nom + " : " + ((GeoPlanJNombre)temp).valeur);
		    } else {
			System.out.println(temp.nom);
		    }
		    temp = temp.suivant;
		}
	    }
	    if(figure.objetLibreActifAuClavier != null) {
		System.out.println("Objet libre actif au clavier :");
		if(figure.objetLibreActifAuClavier.HS) {
		    System.out.print("**HS** ");
		}
		if(figure.objetLibreActifAuClavier.type == GeoPlanJObjet.Point) {
		    System.out.println("point " + figure.objetLibreActifAuClavier.nom + " : " + ((GeoPlanJPoint)figure.objetLibreActifAuClavier).x + ", " + ((GeoPlanJPoint)figure.objetLibreActifAuClavier).y);
		} else if(figure.objetLibreActifAuClavier.type == GeoPlanJObjet.Nombre) {
		    System.out.println("nombre " + figure.objetLibreActifAuClavier.nom + " : " + ((GeoPlanJNombre)figure.objetLibreActifAuClavier).valeur);
		}
	    }
	}
	repaint();
    }
    public void componentHidden(ComponentEvent e) {
    }
    public void componentMoved(ComponentEvent e) {
    }
    public void componentResized(ComponentEvent e) {
	//System.out.println("Component Resized");
	visible = false;
	calibreLaFigure();
	mettreLesEcransAJour();
	visible = true;
    }
    public void componentShown(ComponentEvent e) {
	//System.out.println("Component Shown");
	visible = false;
	calibreLaFigure();
	mettreLesEcransAJour();
	visible = true;
    }
    private void calibreLaFigure() {
	largeur = getSize().width;
	hauteur = getSize().height;
	figure.largeur.valeur = (double)largeur;
	figure.hauteur.valeur = (double)hauteur;
	if(figure.hauteurDesAffichages > (int)(figure.hauteur.valeur/2)) {
	    figure.hauteurDesAffichages = (int)(figure.hauteur.valeur/2);
	}
	if(hauteur < largeur) {
	    double echelle = (double)hauteur / (figure.Xmax - figure.Xmin);
	    figure.uoxy.valeur = echelle;
	    // represente le nombre de pixel par unite de repere
	    ((GeoPlanJNombre)figure.o.antecedents[0]).valeur = -figure.Xmin * echelle + (double)(largeur - hauteur) / 2;
	    // c'est l'abscisse ecran de l'origine
	    ((GeoPlanJNombre)figure.o.antecedents[1]).valeur = figure.Ymax * echelle;
	    // c'est l'ordonnee ecran de l'origine
	} else {
	    double echelle = (double) largeur / (figure.Xmax - figure.Xmin);
	    figure.uoxy.valeur = echelle;
	    // represente le nombre de pixel par unite de repere
	    ((GeoPlanJNombre)figure.o.antecedents[0]).valeur = -figure.Xmin * echelle;
	    // c'est abscisse ecran de l'origine
	    ((GeoPlanJNombre)figure.o.antecedents[1]).valeur = figure.Ymax * echelle + (double)(hauteur - largeur) / 2;
	    // c'est l'ordonnee ecran de l'origine
	}
	//((GeoPlanJNombre)figure.o.antecedents[1]).valeur -= (double)figure.hauteurDesAffichages;
    }
    private void mettreLesEcransAJour() {
	//System.out.println("ICI");
	//System.out.println("hauteur = " + hauteur);
	//System.out.println("hauteurDesAffichages = " + figure.hauteurDesAffichages);
	//System.out.println("largeur = " + largeur);
	figure.o.miseAJour();
	figure.uoxy.suivant.miseAJour();
	figure.vecI.miseAJour();
	figure.vecJ.miseAJour();
	figure.vecJ.suivant.miseAJour();
	figure.vecJ.suivant.suivant.miseAJour();
	figure.roxy.miseAJour();
	//System.out.println("o.x = " + Double.toString(((GeoPlanJNombre)figure.o.antecedents[0]).valeur));
	//System.out.println("o.y = " + Double.toString(((GeoPlanJNombre)figure.o.antecedents[1]).valeur));
	if(figure.offgraph != null) {
	    for(int i = 0 ; i < figure.offgraph.length ; i++) {
		if(figure.offgraph[i] != null) {
		    figure.offgraph[i].dispose();
		}
	    }
	}
	figure.offscreen = new Image[nbCadres + 3];
	figure.offgraph = new Graphics[nbCadres + 3];
	figure.offscreen[0] = createImage(largeur, hauteur);// - figure.hauteurDesAffichages);
	figure.offgraph[0] = figure.offscreen[0].getGraphics();// dessin de la figure
	if(figure.hauteurDesAffichages > 3) {
	    figure.offscreen[1] = createImage(largeur, hauteur);//figure.hauteurDesAffichages - 3);
	    figure.offgraph[1] = figure.offscreen[1].getGraphics();// dessin des affichages
	} else {
	    figure.hauteurDesAffichages = 0;
	}
	figure.traceActive = 0;
	figure.offscreen[2] = createImage(largeur, hauteur);// - figure.hauteurDesAffichages);
	figure.offgraph[2] = figure.offscreen[2].getGraphics();// pour le fond et les traces 
	refaitImageDuFond();
    }
    private void refaitImageDuFond() {
	if(fond != null) {
	    if(largeurDuFond == 0) {
		if (!tracker.checkAll()) {
		    //System.out.println("pas fini de charger");
		    figure.offgraph[2].clearRect(0, 0, largeur, hauteur);// - figure.hauteurDesAffichages);
		} else {
		    largeurDuFond = fond.getWidth(null);
		    hauteurDuFond = fond.getHeight(null);
		    for(int i=0; i< largeur; i+=largeurDuFond) {
			//for(int j=0 ; j < hauteur - figure.hauteurDesAffichages ; j+=hauteurDuFond) {
			for(int j=0 ; j < hauteur ; j+=hauteurDuFond) {
			    figure.offgraph[2].drawImage(fond, i, j, null);
			}
		    }
		}
	    } else {
		//System.out.println("fini de charger");
		//System.out.println("hauteur = " + fond.getHeight(null));
		//System.out.println("largeur = " + fond.getWidth(null));
		for(int i=0; i< largeur; i+=largeurDuFond) {
		    //for(int j=0 ; j < hauteur - figure.hauteurDesAffichages ; j+=hauteurDuFond) {
		    for(int j=0 ; j < hauteur ; j+=hauteurDuFond) {
			figure.offgraph[2].drawImage(fond, i, j, null);
		    }
		}
	    }
	} else {
	    figure.offgraph[2].clearRect(0, 0, largeur, hauteur);// - figure.hauteurDesAffichages);
	}
    }
    public void actionPerformed(ActionEvent e) {
	String label = e.getActionCommand();
	if("Point libre dans le plan".equals(label)) {
	    GeoPlanJDialogue boitepoint = new GeoPlanJDialogue(fdialog, "Points libres", 0, figure);
	    boitepoint.show();
	    repaint();
	}
    }
    /**
     *	la procedure main permet de lancer le programmme en temps
     *	qu'application independante, c'est-a-dire
     *	en dehors d'un navigateur.
     */
    /*
    public static void main(String args[]) {
	Frame f = new Frame("GeoPlan en Java");
	GeoPlanJ gpapplet = new GeoPlanJ();
	gpapplet.init();
	gpapplet.start();
	f.add("Center", gpapplet);
	f.setSize(300, 300);
	f.show();
    }
    */
    public String getAppletInfo() {
	return "GoPlan pour JAVA\nVersion 0.8.0\nA.I.D.-C.R.E.E.M.\nAuteur : Frdric KOTECKI";
    }
    public String[][] getParameterInfo() {
	String[][] info = {
	    {"fichier", "nom du fichier", "Le nom du fichier ainsi que le chemin."},
	};
	return info;
    }
    public void executeLigne(String texte) {
	gpPhrases.executeLigne(texte, figure);
	repaint();	
    }
    public void update(Graphics g) {
	paint(g);
    }
    public void paint(Graphics g) {
	if(!visible) {
	    return;//pour viter les erreurs au redimensionnement
	}
	if("Figure finie".equals(tagEnCours) && figure.offgraph != null) {
	    if(focus == 1) {
		g.setColor(Color.blue);
		g.drawRect(0, 0, largeur-1, hauteur-1);
	    }
	    //largeur = getSize().width;
	    //hauteur = getSize().height;
	    //figure.dessine(offgraph, offgraphAffichage, figure.hauteurDesAffichages);
	    figure.dessine();
	    if(figure.hauteurDesAffichages > 3) {
		g.drawImage(figure.offscreen[1], focus, focus, largeur-focus, figure.hauteurDesAffichages - 3, focus, focus, largeur - focus, figure.hauteurDesAffichages - 3, null);
		g.setColor(Color.black);
		g.drawLine(focus, figure.hauteurDesAffichages - 3, largeur-focus, figure.hauteurDesAffichages - 3);
		g.drawLine(focus, figure.hauteurDesAffichages - 1, largeur-focus, figure.hauteurDesAffichages - 1);
		g.setColor(figure.couleurDeFond);
		g.drawLine(focus, figure.hauteurDesAffichages - 2, largeur-focus, figure.hauteurDesAffichages - 2);
		//figure.offgraph[1].setColor(Color.red);
		figure.offgraph[1].clearRect(0, 0, largeur, figure.hauteurDesAffichages - 3);
	    } else {
		figure.hauteurDesAffichages = focus;
	    }
	    g.drawImage(figure.offscreen[0], focus, figure.hauteurDesAffichages, largeur-focus, hauteur-focus, focus, figure.hauteurDesAffichages, largeur-focus, hauteur-focus, null);
	    figure.offgraph[0].drawImage(figure.offscreen[2], 0, 0, null);
	    //exportation
	    if(exportation && focus == 1) {
		//System.out.println("exportation et focus");
		for(java.util.Enumeration e = getAppletContext().getApplets() ; e.hasMoreElements() ;) {
		    Object ap = e.nextElement();
		    if(ap != this && ap instanceof GeoPlanJ && ((GeoPlanJ)ap).importationPossible()) {
			GeoPlanJObjet temp = figure.roxy.suivant;
			while(temp != null) {
			    if(temp instanceof GeoPlanJNombre) {
				//System.out.println("exportation");
				((GeoPlanJ)ap).importe(((GeoPlanJNombre)temp).nom, ((GeoPlanJNombre)temp).valeur);
			    }
			    temp = temp.suivant;
			}
		    }
		}
	    }
	} else {
	    if(etudeDeLaFigureEnCours) {
		g.setColor(Color.green);
		g.drawString("Chargement de la figure en cours", 100, 100);
	    } else {
		g.setColor(Color.red);
		g.drawString("Erreur dans la figure !", 100, 100);
		//System.out.println("tagEnCours = " + tagEnCours);
	    }
	}
    }
    public void redraw() {
	repaint();
    }
    public void executeTexteDeLaFigure() {
	//stop();
	//setVisible(false);
	tagEnCours = "Figure Geoplan";
	int initLigneCourante = 0;
 	if("Figure Goplan".equals(texteDeLaFigure[0])) {
	    initLigneCourante++;
	    if("Numro de version: ".equals((texteDeLaFigure[1]).substring(0, 19))) {
		initLigneCourante++;
		gpPhrases = new GeoPlanJPhrases(getCodeBase(), "GeoPlan" + (texteDeLaFigure[1]).substring(19, (texteDeLaFigure[1]).length()));
	    } else {
		System.out.println("je ne suis pas parvenu a trouver le numero de version de la figure");
		System.out.println("j'ai trouv " + texteDeLaFigure[1]);
		System.out.println("on essaie de continuer avec \"Numro de version: 2\"");
		gpPhrases = new GeoPlanJPhrases(getCodeBase(), "GeoPlan2");
		//stop();
		//System.exit(-1);
		//return;
	    }
	} else {
	    System.out.println("ce n'est pas une figure GoPlan");
	    System.out.println("j'ai trouv /" + texteDeLaFigure[0] + "/");
	    System.out.println("on essaie de continuer avec \"Figure Goplan\", \"Numro de version: 2\"");
	    gpPhrases = new GeoPlanJPhrases(getCodeBase(), "GeoPlan2");
	    //stop();
	    //System.exit(-1);
	    //return;
	}
	figure = new GeoPlanJFigure();
	figure.couleurDeFond = couleurDeFond;
	figure.metriqueDeFontes = getFontMetrics(new java.awt.Font("New", Font.PLAIN, 12));
	String[] variablesDonnees = {"objet cr", "O"};// ce nom sera remplac plus tard par le nom de l'objet cr par le prototype, de plus il est bien pratique pour viter de laisser cette variable non initialise
	boolean protofonction = false;
	for(int ligneCourante = initLigneCourante ; ligneCourante < texteDeLaFigure.length ; ligneCourante++) {
	    //System.out.println(texteDeLaFigure[ligneCourante]);
	    if("Fin de la figure".equals(texteDeLaFigure[ligneCourante])) {
		if("Figure Geoplan".equals(tagEnCours) || "Commentaire".equals(tagEnCours)) {
		    // peut-on ne pas mettre de Commentaire ? En tout cas, ce n'est pas le comportement par dfaut de cration de figure sous GoPlanW... mme si cela doit tre compris...
		    tagEnCours = "Figure finie";
		    //System.out.println(texteDeLaFigure[ligneCourante]);
		    //System.out.println(tagEnCours);
		} else {
		    System.out.println("il ne peut pas y avoir de \"Fin de figure\" dans un prototype ; celui-ci est-il bien ferm ?");
		    //System.exit(-1);
		    return;
		}
	    } else if("Commentaire".equals(texteDeLaFigure[ligneCourante])) {
		if("Figure Geoplan".equals(tagEnCours)) {
		    tagEnCours = "Commentaire";
		    //System.out.println(texteDeLaFigure[ligneCourante]);
		    //System.out.println(tagEnCours);
		} else {
		    System.out.println("il ne peut pas y avoir de commentaire dans un prototype ; celui-ci est-il bien ferm ?");
		    //System.exit(-1);
		    return;
		}
	    } else if("Figure finie".equals(tagEnCours)) {
		System.out.println("Avertissement : une ligne aprs la fin de la figure a t ignore");
	    } else if("Commentaire".equals(tagEnCours)) {
		commentaires = commentaires + texteDeLaFigure[ligneCourante] + "_";
		// provisoirement, le symbole "_" est utilis pour le retour chariot
	    } else {
		if(texteDeLaFigure[ligneCourante].length() > 10 && "Dbut de [".equals(texteDeLaFigure[ligneCourante].substring(0, 10)) && texteDeLaFigure[ligneCourante].charAt(texteDeLaFigure[ligneCourante].length()-1) == ']') {
		    //System.out.println("dbut de prototype");
		    //System.out.println("tag en cours = " + tagEnCours);
		    //System.out.println("le dernier objet de l'arborescence normale de la figure est " + figure.dernier.nom);
		    if(figure.dernier != figure.roxy) {
			System.out.println("Erreur : les prototypes doivent tre dclars au dbut de la figure");
			//System.exit(-1);
			return;
			//} else {// provisoire
			//System.out.println("OK, le prototype est au dbut");
		    }//fin de provisoire
		    tagEnCours = "Prototype : " + texteDeLaFigure[ligneCourante].substring(10, texteDeLaFigure[ligneCourante].length()-1);
		    //System.out.println("dbut de prototype");
		    //System.out.println(tagEnCours);
		} else if("Description de l'interface".equals(texteDeLaFigure[ligneCourante])) {
		    if(tagEnCours.length() > 12  && "Prototype : ".equals(tagEnCours.substring(0, 12))) {
			if(++ligneCourante != texteDeLaFigure.length) {
			    variablesDonnees[0] = figure.dernier.nom;
			    variablesDonnees[1] = figure.dernier.codeLettre();
			    if(gpPhrases.creeNouveauPrototype(texteDeLaFigure[ligneCourante].trim(), variablesDonnees, protofonction, figure) != 0) {
				System.out.println("problme dans la description de l'interface");
				//System.exit(-1);
				return;
			    } else {
				protofonction = false;// on rinitialise pour le prochain prototype
				int finDePrototype = 0;// 1 c'est la fin normale et -1 fin avec EOF
				// ici on creera la fenetre du prototype et le menu
				// plus tard
				while(finDePrototype == 0) {
				    if(++ligneCourante != texteDeLaFigure.length) {
					if(texteDeLaFigure[ligneCourante].length() > 8 && "Fin de [".equals(texteDeLaFigure[ligneCourante].substring(0, 8)) && texteDeLaFigure[ligneCourante].charAt(texteDeLaFigure[ligneCourante].length()-1) == ']') {
					    if(tagEnCours.equals("Prototype : " + texteDeLaFigure[ligneCourante].substring(8, texteDeLaFigure[ligneCourante].length()-1))) {
						tagEnCours = "Figure Geoplan";
						figure.objetLibreActifAuClavier = null;// car seul les "vrais" objets de la figure peuvent tre actifs au clavier
						figure.nouveauPrototype(figure.roxy);
						variablesDonnees = new String[2];// rinitialisation pour les prototypes suivants
						variablesDonnees[0] = "objet cr";
						variablesDonnees[1] = "O";
						//System.out.println("fin de prototype");
						//System.out.println(tagEnCours);
						finDePrototype = 1;
					    } else {
						System.out.println("la fin de prototype " + texteDeLaFigure[ligneCourante] + " ne correspond pas  un dbut equivalent");
						//System.exit(-1);
						return;
					    }
					}
				    } else {
					finDePrototype = -1;
				    }
				}
				if(finDePrototype == -1) {//le fichier s'est termin avant la fin
				    System.out.println("le fichier se termine au milieu d'un prototype");
				    //System.exit(-1);
				    return;
				}
			    }
			} else {
			    System.out.println("le fichier se termine au milieu d'un prototype");
			    //System.exit(-1);
			    return;
			}
		    } else {
			System.out.println("Erreur : on ne peut pas avoir de \"Description de l'interface\" en dehors d'un prototype");
			//System.exit(-1);
			return;
		    }
		} else {
		    //System.out.println("le tag en cours est " + tagEnCours);
		    if("Prototype : ".equals(tagEnCours.substring(0, 12))) {
			switch(gpPhrases.executeLigne(texteDeLaFigure[ligneCourante].trim(), figure)) {
			case -1:
			    System.out.println("il y a des erreurs dans la phrase : ");
			    System.out.println(texteDeLaFigure[ligneCourante]);
			    System.out.println("etude de la figure interrompue");
			    //System.exit(-1);
			    //break;
			    return;
			case 2:// variable donne
			    String[] temp = new String[variablesDonnees.length+2];
			    System.arraycopy(variablesDonnees, 0, temp, 0, variablesDonnees.length);
			    variablesDonnees = temp;
			    variablesDonnees[variablesDonnees.length - 2] = figure.dernier.nom;
			    variablesDonnees[variablesDonnees.length - 1] = figure.dernier.codeLettre();
				// pour debug
				//System.out.print("les variables donnes sont : ");
				//for(int i = 0 ; i < variablesDonnees.length-1 ; i++) {
				//System.out.print(variablesDonnees[i] + ", ");
				//}
				//System.out.println(variablesDonnees[variablesDonnees.length-1]);
				// fin de debug
			    break;
			case 3:// variable muette
			    protofonction = true;
			    System.out.println("On a trouve une variable muette; elle s'appelle " + figure.dernier.nom);
			    break;
			}
		    } else {
			switch(gpPhrases.executeLigne(texteDeLaFigure[ligneCourante].trim(), figure)) {
			case -1:
			    System.out.println("il y a des erreurs dans la phrase : ");
			    System.out.println(texteDeLaFigure[ligneCourante]);
			    System.out.println("etude de la figure interrompue");
			    //System.exit(-1);
			    //break;
			    return;
			case 2:// variable donne
			    System.out.println("Erreur : variable donne ne doit tre utilise que dans les prototypes");
			    //System.exit(-1);
			    //break;
			    return;
			case 3:// variable muette
			    System.out.println("Erreur : variable muette ne doit tre utilise que dans les prototypes");
			    //System.exit(-1);
			    //break;
			    return;
			}
		    }
		}
	    }
	    //System.out.println("executeLigne");
	}
	if(!"Figure finie".equals(tagEnCours)) {
	    System.out.println("Attention : le fichier de la figure est termine sans \"Fin de figure\"");
	    System.out.println("le tag en cours est " + tagEnCours);
	    tagEnCours = "Figure finie";
	}
	if(largeur != 0) {
	    calibreLaFigure();
	    mettreLesEcransAJour();
	}
	//System.out.println("apres les executeLigne");
	//setVisible(true);
	//System.out.println("on est pass par l");
	//start();
	//dispatchEvent(new java.awt.event.ComponentEvent(this, java.awt.event.ComponentEvent.COMPONENT_RESIZED));//tentative pour forcer la mise  jour aprs un rechargement
    }
    public double ValeurScalaireDouble(String nom) {
	GeoPlanJObjet temp = figure.objetNomme(nom);
	if(temp == null) {
	    return(0);
	}
	if(temp.type != GeoPlanJObjet.Nombre) {
	    return(0);
	}
	return(((GeoPlanJNombre)temp).valeur);
    }
    public void AffecteScalaire(String nom, double val) {
	GeoPlanJObjet temp = figure.objetNomme(nom);
	if(temp == null) {
	    return;
	}
	if(temp.type != GeoPlanJObjet.Nombre) {
	    return;
	}
	if((temp.sousType != GeoPlanJNombre.Normal) || (temp.param != GeoPlanJNombre.Numerique)) {
	    return;
	}
	if(((temp.nom.charAt(0) >= '0') && (temp.nom.charAt(0) <= '9')) || (temp.nom.charAt(0) == '.')) {//cas des constantes numeriques
	    return;
	}
	((GeoPlanJNombre)temp).valeur = val;
    }
    public boolean importationPossible() {
	return(importation);
    }
    public void importe(String nom, double valeur) {
	GeoPlanJObjet temp = figure.objetNomme(nom);
	if((temp != null) && (temp instanceof GeoPlanJNombre) && (((GeoPlanJNombre)temp).sousType == GeoPlanJNombre.Normal) && (((GeoPlanJNombre)temp).param == GeoPlanJNombre.Numerique) && (((GeoPlanJNombre)temp).antecedents.length == 0)) {
	    ((GeoPlanJNombre)temp).valeur = valeur;
	}
    }
}
