import java.awt.Graphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;

class GeoPlanJAffichage extends GeoPlanJObjetDessinable {
    public final static int Scalaire = 0;
    public final static int Coordonnees = 1;
    public final static int EquationDeDroite = 2;
    public final static int EquationReduiteDeDroite = 3;
    public final static int LongueurDunSegment = 4;
    public final static int AireDunTriangle = 5;
    public final static int MesureDunAngle = 6;
    public final static int Texte = 7;
    int x, y;
    String texte;
    GeoPlanJAffichage(String nom, GeoPlanJObjet[] antecedents, int sousType, int param, GeoPlanJFigure figure, int numeroEcran) {
	this.nom = nom;
	this.type = GeoPlanJObjet.Affichage;
	this.antecedents = antecedents;
	this.sousType = sousType;
	this.param = param;// sert  la prcision d'affichage
	this.figure = figure;
	this.numeroEcran = numeroEcran;
	this.couleur = Color.black;
	this.x = (int)(Math.random()*figure.largeur.valeur);
	this.y = 0;
	if(figure.hauteurDesAffichages == 0) {
	    figure.hauteurDesAffichages = 50;
	}
    }
    GeoPlanJAffichage(String nom, String texte, int sousType, int param, GeoPlanJFigure figure, int numeroEcran) {
	this.nom = nom;
	this.type = GeoPlanJObjet.Affichage;
	this.texte = texte;
	this.sousType = sousType;
	this.param = param;// sert  la prcision d'affichage
	this.figure = figure;
	this.numeroEcran = numeroEcran;
	this.couleur = Color.black;
	this.x = (int)(Math.random()*figure.largeur.valeur);
	this.y = 0;
    }
    // particularitesParDefaut sert lorsqu'on utilise la phrase Objet dessinable ... particularits ...
    void particularitesParDefaut() {
	couleur = Color.black;
    }
    void particularite(String texte) {
	Color tempColor = figure.couleurNommee(texte);
	if(tempColor != null) {
	    couleur = tempColor;
	    return;
	} else if("dessin".equals(texte)) {
	    epaisseur = 2;
	} else if("non dessin".equals(texte)) {
	    epaisseur = 0;
	}
    }
    void dessine() {
	if(!HS) {
	    figure.offgraph[numeroEcran].setColor(couleur);
	    figure.offgraph[numeroEcran].drawString(texte, x, y + figure.metriqueDeFontes.getAscent() );
	}
    }
    void miseAJour() {
	for(int i = 0 ; i < antecedents.length ; i++) {
	    if(antecedents[i].HS) {
		this.HS = true;
		return;
	    }
	}
	switch(sousType) {
	default:
	    //cas des Prototypes
	    GeoPlanJObjet proto = miseAJourPrototype();
	    //System.out.println("miseAJourPrototype renvoie l'objet " + proto.nom);
	    //System.out.println(" de params : " + ((GeoPlanJPoint)proto).x + ", " + ((GeoPlanJPoint)proto).y);
	    if(proto == null) {
		HS = true;
		return;
	    }
	    this.x = ((GeoPlanJAffichage)proto).x;
	    this.y = ((GeoPlanJAffichage)proto).y;
	    //System.out.println("prototype mis  jour");
	    HS = false;
	    return;
	case Normal:
	    switch(param) {
	    case Scalaire:
		texte = ((GeoPlanJNombre)antecedents[0]).nom;
		texte = texte.concat(" : ");
		double temp = ((GeoPlanJNombre)antecedents[0]).valeur;
		double temp2 = ((GeoPlanJNombre)antecedents[1]).valeur;
		if(temp2 < 0 || temp2 > 6) {
		    HS = true;
		    return;
		}// la prcision est un entier (ou presque) entre 0 et 6
		if((temp2 - Math.floor(temp2 + 0.5d)) > 0.0001) {
		    HS = true;
		    return;
		}// ce n'est pas un entier
		temp2 = Math.pow(10, Math.floor(temp2 + 0.5d));
		temp = Math.floor(temp * temp2 + 0.5d) / temp2;
		texte = texte.concat(texte.valueOf(temp));
		HS = false;
		break;
	    case Coordonnees:
		texte = ((GeoPlanJPoint)antecedents[0]).nom;
		texte = texte.concat(" : (");
		double tempx = ((GeoPlanJRepere)antecedents[1]).Ax * ((GeoPlanJPoint)antecedents[0]).x
		    + ((GeoPlanJRepere)antecedents[1]).Bx * ((GeoPlanJPoint)antecedents[0]).y
		    + ((GeoPlanJRepere)antecedents[1]).Cx;
		double tempy = ((GeoPlanJRepere)antecedents[1]).Ay * ((GeoPlanJPoint)antecedents[0]).x
		    + ((GeoPlanJRepere)antecedents[1]).By * ((GeoPlanJPoint)antecedents[0]).y
		    + ((GeoPlanJRepere)antecedents[1]).Cy;
		temp2 = Math.round(((GeoPlanJNombre)antecedents[2]).valeur);
		if(temp2 < 0 || temp2 > 6) {
		    HS = true;
		    return;
		}
		if(temp2 == 0) {
		    texte = texte.concat(texte.valueOf((int)(tempx + 0.5)));
		    texte = texte.concat(", ");
		    texte = texte.concat(texte.valueOf((int)(tempy + 0.5)));
		    texte = texte.concat(")");
		} else {
		    temp2 = Math.pow(10, temp2);
		    texte = texte.concat(texte.valueOf(Math.round(tempx * temp2)/temp2));
		    texte = texte.concat(", ");
		    texte = texte.concat(texte.valueOf(Math.round(tempy * temp2)/temp2));
		    texte = texte.concat(")");
		}
		HS = false;
		break;
	    case EquationDeDroite:
		texte = "quation de ";
		texte = texte.concat(((GeoPlanJDroite)antecedents[0]).nom);
		texte = texte.concat(" : ");
		double dx = ((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0;
		double dy = ((GeoPlanJDroite)antecedents[0]).y1 - ((GeoPlanJDroite)antecedents[0]).y0;
		double a = ((GeoPlanJRepere)antecedents[1]).Ay * dx + ((GeoPlanJRepere)antecedents[1]).By * dy;
		double b = -(((GeoPlanJRepere)antecedents[1]).Ax * dx + ((GeoPlanJRepere)antecedents[1]).Bx * dy);
		double c = -a * (((GeoPlanJRepere)antecedents[1]).Ax * ((GeoPlanJDroite)antecedents[0]).x0 + ((GeoPlanJRepere)antecedents[1]).Bx * ((GeoPlanJDroite)antecedents[0]).y0 + ((GeoPlanJRepere)antecedents[1]).Cx) - b * (((GeoPlanJRepere)antecedents[1]).Ay * ((GeoPlanJDroite)antecedents[0]).x0 + ((GeoPlanJRepere)antecedents[1]).By * ((GeoPlanJDroite)antecedents[0]).y0 + ((GeoPlanJRepere)antecedents[1]).Cy);
		temp2 = Math.round(((GeoPlanJNombre)antecedents[2]).valeur);
		if(temp2 < 0 || temp2 > 6) {
		    HS = true;
		    return;
		}
		if(temp2 == 0) {
		    a = Math.round(a);
		    b = Math.round(b);
		    c = Math.round(c);
		    if(a != 0) {
			texte = texte.concat(texte.valueOf((int)a));
			texte = texte.concat("X");
			if(b != 0) {
			    if(b > 0) {
				texte = texte.concat("+");
			    }
			    texte = texte.concat(texte.valueOf((int)b));
			    texte = texte.concat("Y");
			}
			if(c != 0) {
			    if(c > 0) {
				texte = texte.concat("+");
			    }
			    texte = texte.concat(texte.valueOf((int)c));
			}
		    } else {
			texte = texte.concat(texte.valueOf((int)b));
			texte = texte.concat("Y");
			if(c != 0) {
			    if(c > 0) {
				texte = texte.concat("+");
			    }
			    texte = texte.concat(texte.valueOf((int)c));
			}
		    }
		} else {
		    temp2 = Math.pow(10, temp2);
		    a = Math.round(a * temp2)/temp2;
		    b = Math.round(b * temp2)/temp2;
		    c = Math.round(c * temp2)/temp2;
		    if(a != 0) {
			texte = texte.concat(texte.valueOf(a));
			texte = texte.concat("X");
			if(b != 0) {
			    if(b > 0) {
				texte = texte.concat("+");
			    }
			    texte = texte.concat(texte.valueOf(b));
			    texte = texte.concat("Y");
			}
			if(c != 0) {
			    if(c > 0) {
				texte = texte.concat("+");
			    }
			    texte = texte.concat(texte.valueOf(c));
			}
		    } else {
			texte = texte.concat(texte.valueOf(b));
			texte = texte.concat("Y");
			if(c != 0) {
			    if(c > 0) {
				texte = texte.concat("+");
			    }
			    texte = texte.concat(texte.valueOf(c));
			}
		    }
		}
		texte = texte.concat("=0");
		HS = false;
		break;
	    case EquationReduiteDeDroite:
		dx = ((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0;
		dy = ((GeoPlanJDroite)antecedents[0]).y1 - ((GeoPlanJDroite)antecedents[0]).y0;
		b = ((GeoPlanJRepere)antecedents[1]).Ax * dx + ((GeoPlanJRepere)antecedents[1]).Bx * dy;
		if(Math.abs(b) < 0.00001) {
		    HS = true;
		    return;
		}
		a = (((GeoPlanJRepere)antecedents[1]).Ay * dx + ((GeoPlanJRepere)antecedents[1]).By * dy) / b;
		c = -a * (((GeoPlanJRepere)antecedents[1]).Ax * ((GeoPlanJDroite)antecedents[0]).x0 + ((GeoPlanJRepere)antecedents[1]).Bx * ((GeoPlanJDroite)antecedents[0]).y0 + ((GeoPlanJRepere)antecedents[1]).Cx) + (((GeoPlanJRepere)antecedents[1]).Ay * ((GeoPlanJDroite)antecedents[0]).x0 + ((GeoPlanJRepere)antecedents[1]).By * ((GeoPlanJDroite)antecedents[0]).y0 + ((GeoPlanJRepere)antecedents[1]).Cy);
		temp2 = Math.round(((GeoPlanJNombre)antecedents[2]).valeur);
		if(temp2 < 0 || temp2 > 6) {
		    HS = true;
		    return;
		}
		texte = "quation rduite de ";
		texte = texte.concat(((GeoPlanJDroite)antecedents[0]).nom);
		texte = texte.concat(" : Y=");
		if(temp2 == 0) {
		    a = Math.round(a);
		    b = Math.round(b);
		    c = Math.round(c);
		    if(a != 0) {
			texte = texte.concat(texte.valueOf((int)a));
			texte = texte.concat("X");
			if(c != 0) {
			    if(c>0) {
				texte = texte.concat("+");
			    }
			    texte = texte.concat(texte.valueOf((int)c));
			}
		    } else {
			texte = texte.concat(texte.valueOf((int)c));
		    }
		} else {
		    temp2 = Math.pow(10, temp2);
		    a = Math.round(a * temp2)/temp2;
		    b = Math.round(b * temp2)/temp2;
		    c = Math.round(c * temp2)/temp2;
		    if(a != 0) {
			texte = texte.concat(texte.valueOf(a));
			texte = texte.concat("X");
			if(c != 0) {
			    if(c > 0) {
				texte = texte.concat("+");
			    }
			    texte = texte.concat(texte.valueOf(c));
			}
		    } else {
			texte = texte.concat(texte.valueOf(c));
		    }
		}
		HS = false;
		break;
	    case LongueurDunSegment:
		texte = "longueur de ";
		texte = texte.concat(((GeoPlanJDroite)antecedents[0]).nom);
		texte = texte.concat(" : ");
		temp2 = Math.round(((GeoPlanJNombre)antecedents[2]).valeur);
		if(temp2 < 0 || temp2 > 6) {
		    HS = true;
		    return;
		}
		if(temp2 == 0) {
		    texte = texte.concat(texte.valueOf((int)(((GeoPlanJNombre)antecedents[1]).valeur + 0.5)));
		} else {
		    temp2 = Math.pow(10, temp2);
		    texte = texte.concat(texte.valueOf(Math.round(((GeoPlanJNombre)antecedents[1]).valeur * temp2)/temp2));
		}
		HS = false;
		break;
	    case AireDunTriangle:
		texte = "aire de ";
		texte = texte.concat(((GeoPlanJPoint)antecedents[0]).nom);
		texte = texte.concat(((GeoPlanJPoint)antecedents[1]).nom);
		texte = texte.concat(((GeoPlanJPoint)antecedents[2]).nom);
		texte = texte.concat(" : ");
		temp2 = Math.round(((GeoPlanJNombre)antecedents[4]).valeur);
		if(temp2 < 0 || temp2 > 6) {
		    HS = true;
		    return;
		}
		if(temp2 == 0) {
		    texte = texte.concat(texte.valueOf((int)(((GeoPlanJNombre)antecedents[3]).valeur + 0.5)));
		} else {
		    temp2 = Math.pow(10, temp2);
		    texte = texte.concat(texte.valueOf(Math.round(((GeoPlanJNombre)antecedents[3]).valeur * temp2)/temp2));
		}
		HS = false;
		break;
	    case MesureDunAngle:
		texte = "mesure de ";
		texte = texte.concat(((GeoPlanJPoint)antecedents[0]).nom);
		texte = texte.concat(((GeoPlanJPoint)antecedents[1]).nom);
		texte = texte.concat(((GeoPlanJPoint)antecedents[2]).nom);
		texte = texte.concat(" : ");
		temp2 = Math.round(((GeoPlanJNombre)antecedents[4]).valeur);
		if(temp2 < 0 || temp2 > 6) {
		    HS = true;
		    return;
		}
		if(temp2 == 0) {
		    texte = texte.concat(texte.valueOf((int)(((GeoPlanJNombre)antecedents[3]).valeur + 0.5)));
		} else {
		    temp2 = Math.pow(10, temp2);
		    texte = texte.concat(texte.valueOf(Math.round(((GeoPlanJNombre)antecedents[3]).valeur * temp2)/temp2));
		}
		HS = false;
		break;
	    case Texte:
		break;
	    default:
		System.out.println("ERREUR!!! cas non prvu, pour Affichage normal");
		HS = true;
		return;
	    }
	}
    }
    void nouvellesCoords(int newX, int newY) {
	//il faudra affecter les nouvelles coordonnes en fonction des problmes de bord
	return;
    }
    int copie(GeoPlanJObjet obj) { // faut-il ajouter un booleen pour copier aussi la couleur, ...
	if(obj.type == GeoPlanJObjet.Affichage) {
	    this.x = ((GeoPlanJAffichage)obj).x;
	    this.y = ((GeoPlanJAffichage)obj).y;
	    return(0);
	} else {
	    System.out.println("Erreur : tentative de copier un objet de mauvais type");
	    return(-1);
	}
    }
}
