import java.awt.Graphics;
import java.awt.Color;

class GeoPlanJArc extends GeoPlanJObjetDessinable {
    double x;
    double y;
    double R;
    double angleDebut;
    double angleTotal;

    GeoPlanJArc(String nom, GeoPlanJObjet[] antecedents, int sousType, int param, GeoPlanJFigure figure, int numeroEcran) {
	this.numeroEcran = numeroEcran;
	this.nom = nom;
	this.type = GeoPlanJObjet.Arc;
	this.antecedents = antecedents;
	this.sousType = sousType;
	this.param = param;
	this.figure = figure;
	this.couleur = Color.black;
    }
    void particularitesParDefaut() {
	couleur = Color.black;
	epaisseur = 1;
    }
    void particularite(String texte) {
	Color tempColor = figure.couleurNommee(texte);
	if(tempColor != null) {
	    couleur = tempColor;
	    return;
	} else if("rempli avec la couleur du bord".equals(texte)) {
	    epaisseur = 3;
	    return;
	} else if("dessin".equals(texte)) {
	    epaisseur = 1;
	    return;
	} else if("non dessin".equals(texte)) {
	    epaisseur = 0;
	    return;
	} else if("trait pais".equals(texte)) {
	    epaisseur = 2;
	    return;
	} else {
	    System.out.println("particularite " + texte + " est inconnue, donc ignoree");
	}
    }
    void dessine() {
	if(!HS) {
	    figure.offgraph[numeroEcran].setColor(couleur);
	    switch(epaisseur) {
	    case 3:// rempli
		figure.offgraph[numeroEcran * figure.traceActive].fillArc((int)(x + 0.5) - (int)(R + 0.5), (int)(y + 0.5) - (int)(R + 0.5), 2*(int)(R + 0.5),  2*(int)(R + 0.5), (int)(angleDebut + 0.5), (int)(angleTotal + 0.5));
		break;
	    case 2:
		figure.offgraph[numeroEcran * figure.traceActive].drawArc((int)(x + 0.5) - (int)(R + 1.5), (int)(y + 0.5) - (int)(R + 1.5), 2*(int)(R + 1.5),  2*(int)(R + 1.5), (int)(angleDebut + 0.5), (int)(angleTotal + 0.5));
		//pas de break
	    case 1:
		figure.offgraph[numeroEcran * figure.traceActive].drawArc((int)(x + 0.5) - (int)(R + 0.5), (int)(y + 0.5) - (int)(R + 0.5), 2*(int)(R + 0.5),  2*(int)(R + 0.5), (int)(angleDebut + 0.5), (int)(angleTotal + 0.5));
		break;
	    }
	}
    }
    void miseAJour() {
	for(int i = 0 ; i < antecedents.length ; i++) {
	    if(antecedents[i].HS) {
		this.HS = true;
		return;
	    }
	}
	switch(sousType) {
	case Normal:
	    switch(antecedents.length) {
	    case 2:
		switch(antecedents[0].type) {
		case Point://premier point du demi-cercle
		    switch(antecedents[1].type) {
		    case Point://second point du demi-cercle
			x = (((GeoPlanJPoint)antecedents[0]).x + ((GeoPlanJPoint)antecedents[1]).x) / 2;
			y = (((GeoPlanJPoint)antecedents[0]).y + ((GeoPlanJPoint)antecedents[1]).y) / 2;
			double dx = ((GeoPlanJPoint)antecedents[0]).x - x;
			double dy = ((GeoPlanJPoint)antecedents[0]).y - y;
			R = Math.sqrt(dx * dx + dy * dy);
			angleDebut = -180 * Math.atan2(dy, dx) / Math.PI;//angle de dbut en degr
			    //le signe -  cause du sens indirect de l'cran
			dx = ((GeoPlanJPoint)antecedents[1]).x - x;
			dy = ((GeoPlanJPoint)antecedents[1]).y - y;
			angleTotal = -180 * Math.atan2(dy, dx) / Math.PI;
			//le signe -  cause du sens indirect de l'cran
			if(angleTotal < angleDebut) {
			    angleTotal += 360 - angleDebut;
			} else {
			    angleTotal -= angleDebut;
			}
			HS = false;
			break;
		    default:
			System.out.println("Erreur : type du deuxime antcdent de " + this.nom + " non prvu");
			HS = true;
			break;
		    }
		    break;
		default:
		    System.out.println("Erreur : type du premier antcdent de " + this.nom + " non prvu");
		    HS = true;
		    break;
		}
		break;
	    case 3:
		switch(antecedents[0].type) {
		case Point://Origine de l'arc
		    switch(antecedents[1].type) {
		    case Point://Extrmit de l'arc
			switch(antecedents[2].type) {
			case Point://sur le cercle de centre
			    x = ((GeoPlanJPoint)antecedents[2]).x;
			    y = ((GeoPlanJPoint)antecedents[2]).y;
			    double dx = ((GeoPlanJPoint)antecedents[0]).x - x;
			    double dy = ((GeoPlanJPoint)antecedents[0]).y - y;
			    R = Math.sqrt(dx * dx + dy * dy);
			    angleDebut = -180 * Math.atan2(dy, dx) / Math.PI;//angle de dbut en degr
			    //le signe -  cause du sens indirect de l'cran
			    dx = ((GeoPlanJPoint)antecedents[1]).x - x;
			    dy = ((GeoPlanJPoint)antecedents[1]).y - y;
			    if(Math.abs(Math.sqrt(dx * dx + dy * dy) - R) > 0.00001) {
				HS = true;
				return;
			    }
			    angleTotal = -180 * Math.atan2(dy, dx) / Math.PI;
			    //le signe -  cause du sens indirect de l'cran
			    if(angleTotal < angleDebut) {
				angleTotal += 360 - angleDebut;
			    } else {
				angleTotal -= angleDebut;
			    }
			    HS = false;
			    break;
			case Cercle://sur le cercle
			    x = ((GeoPlanJCercle)antecedents[2]).x;
			    y = ((GeoPlanJCercle)antecedents[2]).y;
			    dx = ((GeoPlanJPoint)antecedents[0]).x - x;
			    dy = ((GeoPlanJPoint)antecedents[0]).y - y;
			    R = ((GeoPlanJCercle)antecedents[2]).R;
			    if(Math.abs(Math.sqrt(dx * dx + dy * dy) - R) > 0.00001) {
				HS = true;
				return;
			    }
			    angleDebut = -180 * Math.atan2(dy, dx) / Math.PI;//angle de dbut en degr
			    //le signe -  cause du sens indirect de l'cran
			    dx = ((GeoPlanJPoint)antecedents[1]).x - x;
			    dy = ((GeoPlanJPoint)antecedents[1]).y - y;
			    if(Math.abs(Math.sqrt(dx * dx + dy * dy) - R) > 0.00001) {
				HS = true;
				return;
			    }
			    angleTotal = -180 * Math.atan2(dy, dx) / Math.PI;
			    //le signe -  cause du sens indirect de l'cran
			    if(angleTotal < angleDebut) {
				angleTotal += 360 - angleDebut;
			    } else {
				angleTotal -= angleDebut;
			    }
			    HS = false;
			    break;
			default:
			    System.out.println("Erreur : type du troisime antcdent de " + this.nom + " non prvu");
			    HS = true;
			    break;
			}
			break;
		    default:
			System.out.println("Erreur : type du deuxime antcdent de " + this.nom + " non prvu");
			HS = true;
			break;
		    }
		    break;
		default:
		    System.out.println("Erreur : type du premier antcdent de " + this.nom + " non prvu");
		    HS = true;
		    break;
		}
		break;
	    default:
		System.out.println("Erreur : type de " + this.nom + " non prvu");
		System.out.println("antecedents.length = " + Integer.toString(antecedents.length));
		HS = true;
		break;
	    }
	    break;
	default:
	    // cas des prototypes
	    GeoPlanJObjet proto = miseAJourPrototype();
	    if(proto == null) {
		HS = true;
		//System.out.println("HS");
		return;
	    }
	    this.x = ((GeoPlanJArc)proto).x;
	    this.y = ((GeoPlanJArc)proto).y;
	    this.R = ((GeoPlanJArc)proto).R;
	    this.angleDebut = ((GeoPlanJArc)proto).angleDebut;
	    this.angleTotal = ((GeoPlanJArc)proto).angleTotal;
	    HS = false;
	    break;
	}
    }
    int copie(GeoPlanJObjet obj) {
	if(obj.type == GeoPlanJObjet.Arc) {
	    this.x = ((GeoPlanJArc)obj).x;
	    this.y = ((GeoPlanJArc)obj).y;
	    this.R = ((GeoPlanJArc)obj).R;
	    this.angleDebut = ((GeoPlanJArc)obj).angleDebut;
	    this.angleTotal = ((GeoPlanJArc)obj).angleTotal;
	    return(0);
	} else {
	    System.out.println("Erreur : tentative de copier un objet de mauvais type");
	    return(-1);
	}
    }
}
