import java.awt.Graphics;
import java.awt.Color;

class GeoPlanJDemiPlan extends GeoPlanJObjetDessinable {
    public static final int DemiPlanOuvert = 1;
    public static final int DemiPlanFerme = 2;
    int nombreDePoints;
    int[] x;
    int[] y;
    GeoPlanJDemiPlan(String nom, GeoPlanJObjet[] antecedents, int sousType, int param, GeoPlanJFigure figure, int numeroEcran) {
	this.numeroEcran = numeroEcran;
	this.nom = nom;
	this.type = GeoPlanJObjet.Polygone;
	this.antecedents = antecedents;
	this.sousType = sousType;
	this.param = param;
	this.figure = figure;
	this.couleur = Color.black;
	x = new int[5];//on prend 5 mme si parfois, 3 ou 4 suffisent
	y = new int[5];
    }
    void particularitesParDefaut() {
	couleur = Color.black;
	epaisseur = 1;
    }
    void particularite(String texte) {
	Color tempColor = figure.couleurNommee(texte);
	if(tempColor != null) {
	    couleur = tempColor;
	    //} else if("rempli avec la couleur du bord".equals(texte)) {
	    //epaisseur = 3;
	} else if("dessin".equals(texte)) {
	    epaisseur = 1;
	} else if("non dessin".equals(texte)) {
	    epaisseur = 0;
	    //} else if("tiret".equals(texte)) {
	    //tiret = true;
	    //} else if("trait pais".equals(texte)) {
	    //epaisseur = 2;
	} else {
	    System.out.println("particularite " + texte + " est inconnue, donc ignoree");
	}
    }
    void dessine() {
	if(!HS) {
	    figure.offgraph[numeroEcran].setColor(couleur);
	    figure.offgraph[numeroEcran * figure.traceActive].fillPolygon(x, y, nombreDePoints);
	}
    }
    void miseAJour() {
	for(int i = 0 ; i < antecedents.length ; i++) {
	    if(antecedents[i].HS) {
		this.HS = true;
		return;
	    }
	}
	switch(sousType) {
	case Normal:
	    switch(antecedents.length) {
	    case 2://une droite et un point
		double vecx = ((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0;
		double vecy = ((GeoPlanJDroite)antecedents[0]).y1 - ((GeoPlanJDroite)antecedents[0]).y0;
		double signe = vecy * ( ((GeoPlanJPoint)antecedents[1]).x - ((GeoPlanJDroite)antecedents[0]).x0 )
		    - vecx * ( ((GeoPlanJPoint)antecedents[1]).y - ((GeoPlanJDroite)antecedents[0]).y0 );
		double prod0, prod1, debprod;
		boolean inside, debinside;
		int val = 0;
		if(Math.abs(signe) < 0.00001) {//le point est alors considr sur la droite
		    HS = true;
		    return;
		} else if(signe < 0) {
		    vecx = -vecx;
		    vecy = -vecy;
		}
		if( (prod0 = vecy * ( - ((GeoPlanJDroite)antecedents[0]).x0 )
		     - vecx * ( - ((GeoPlanJDroite)antecedents[0]).y0 )) > 0) {// le premier point est bon
		    x[val] = 0;
		    y[val++] = 0;
		    inside = true;
		    debinside = true;
		} else {//le premier point est mauvais
		    inside = false;
		    debinside = false;
		}
		debprod = prod0;
		if( (prod1 = vecy * (figure.largeur.valeur - ((GeoPlanJDroite)antecedents[0]).x0 )
		     - vecx * ( - ((GeoPlanJDroite)antecedents[0]).y0 )) > 0) {// le second point est bon
		    if(!inside) {
			x[val] = (int)(prod0 * figure.largeur.valeur / (prod0 - prod1) + 0.5);
			y[val++] = 0;
			inside = true;
		    }
		    x[val] = (int)(figure.largeur.valeur + 0.5);
		    y[val++] = 0;
		} else {//le second point est mauvais
		    if(inside) {
			x[val] = (int)(prod0 * figure.largeur.valeur / (prod0 - prod1) + 0.5);
			y[val++] = 0;
			inside = false;
		    }
		}
		prod0 = prod1;
		if( (prod1 = vecy * (figure.largeur.valeur - ((GeoPlanJDroite)antecedents[0]).x0 )
		     - vecx * (figure.hauteur.valeur - ((GeoPlanJDroite)antecedents[0]).y0 )) > 0) {// le troisime point est bon
		    if(!inside) {
			x[val] = (int)(figure.largeur.valeur + 0.5);
			y[val++] = (int)(prod0 * figure.hauteur.valeur / (prod0 - prod1) + 0.5);
			inside = true;
		    }
		    x[val] = (int)(figure.largeur.valeur + 0.5);
		    y[val++] = (int)(figure.hauteur.valeur + 0.5);
		} else {//le troisime point est mauvais
		    if(inside) {
			x[val] = (int)(figure.largeur.valeur + 0.5);
			y[val++] = (int)(prod0 * figure.hauteur.valeur / (prod0 - prod1) + 0.5);
			inside = false;
		    }
		}
		prod0 = prod1;
		if( (prod1 = vecy * ( - ((GeoPlanJDroite)antecedents[0]).x0 )
		     - vecx * (figure.hauteur.valeur - ((GeoPlanJDroite)antecedents[0]).y0 )) > 0) {// le quatrime point est bon
		    if(!inside) {
			x[val] = (int)(prod1 * figure.largeur.valeur / (prod1 - prod0) + 0.5);
			y[val++] = (int)(figure.hauteur.valeur + 0.5);
			inside = true;
		    }
		    x[val] = 0;
		    y[val++] = (int)(figure.hauteur.valeur + 0.5);
		} else {//le quatrime point est mauvais
		    if(inside) {
			x[val] = (int)(prod1 * figure.largeur.valeur / (prod1 - prod0) + 0.5);
			y[val++] = (int)(figure.hauteur.valeur + 0.5);
			inside = false;
		    }
		}
		if(inside ^ debinside) {
		    x[val] = 0;
		    y[val++] = (int)(debprod * figure.hauteur.valeur / (debprod - prod1) + 0.5);
		}
		nombreDePoints = val;
		/*
		for(int i = 0 ; i < val ; i++) {
		    System.out.println("x[" + i + "] = " + x[i]);
		    System.out.println("y[" + i + "] = " + y[i]);
		}
		HS = true;
		*/
		break;
	    default:
		System.out.println("Erreur : type de " + this.nom + " non prvu");
		HS = true;
		break;
	    }
	    break;
	default:
	    // cas des prototypes
	    GeoPlanJObjet proto = miseAJourPrototype();
	    if(proto == null) {
		HS = true;
		//System.out.println("HS");
		return;
	    }
	    this.x = new int[((GeoPlanJDemiPlan)proto).x.length];
	    System.arraycopy(((GeoPlanJDemiPlan)proto).x, 0, this.x, 0, this.x.length);
	    this.y = new int[((GeoPlanJDemiPlan)proto).y.length];
	    System.arraycopy(((GeoPlanJDemiPlan)proto).y, 0, this.y, 0, this.y.length);
	    HS = false;
	    break;
	}
    }
    int copie(GeoPlanJObjet obj) {
	if(obj.type == GeoPlanJObjet.DemiPlan) {
	    this.x = new int[((GeoPlanJDemiPlan)obj).x.length];
	    System.arraycopy(((GeoPlanJDemiPlan)obj).x, 0, this.x, 0, this.x.length);
	    this.y = new int[((GeoPlanJDemiPlan)obj).y.length];
	    System.arraycopy(((GeoPlanJDemiPlan)obj).y, 0, this.y, 0, this.y.length);
	    return(0);
	} else {
	    System.out.println("Erreur : tentative de copier un objet de mauvais type");
	    return(-1);
	}
    }
}
