import java.awt.*;
import java.awt.event.*;
/**
 *	boite de dialogue
 *	il faut creer un frame dans l'appelant meme si ca n'apparait pas
 */
class GeoPlanJDialogue extends Dialog
    implements ActionListener {
    public static final int POINTSLIBRES = 0;
    public static final int POINTREPEREPLAN = 1;
    int val=0;
    TextField textBox;
    GeoPlanJFigure fig;

    GeoPlanJDialogue(Frame frame, String nom, int type, GeoPlanJFigure fig) {
	super(frame, nom, true);
	this.fig = fig;
	switch(type) {
	case POINTSLIBRES:
	    setSize(400, 100);
	    Panel panneau = new Panel();
	    panneau.add(new Label("Nom des points :"));
	    textBox = new TextField("", 16);
	    //textBox.setActionCommand("Ok");
	    textBox.addActionListener(this);
	    panneau.add(textBox);
	    Button bouton = new Button("R");
	    bouton.setActionCommand("Rappel");
	    bouton.addActionListener(this);
	    panneau.add(bouton);
	    add("North", panneau);
	    panneau = new Panel();
	    bouton = new Button("Aide");
	    bouton.setActionCommand("Help");
	    bouton.addActionListener(this);
	    panneau.add(bouton);
	    bouton = new Button("Annuler");
	    bouton.setActionCommand("Cancel");
	    bouton.addActionListener(this);
	    panneau.add(bouton);
	    bouton = new Button("Ok");
	    bouton.setActionCommand("Ok");
	    bouton.addActionListener(this);
	    panneau.add(bouton);
	    add("South", panneau);
	    pack();
	}
    }
    public void actionPerformed(ActionEvent e) {
	String label = e.getActionCommand();
	//System.out.println("action de dialogue" + label);
	if(label.equals("Ok")) {
	    creePoints(textBox.getText());
	    dispose();
	} else if(label.equals("Rappel")) {
	    val=3;
	} else if(label.equals("Help")) {
	    val=2;
	} else if(label.equals("Cancel")) {
	    // si CANCEL, on ne fait rien et on sort
	    dispose();
	} else {
	    // c'est la textBox qui a fait l'venement...
	    // elle a renvoy son texte
	    creePoints(label);
	    dispose();
	}
    }
    void creePoints(String points) {
	String M;
	while(true) {
	    if("".equals(points)) {
		break;
	    }
	    if((M = point(points)) == null) {
		break;
	    }
	    GeoPlanJObjet[] tmpObj = new GeoPlanJObjet[3];
	    tmpObj[0] = new GeoPlanJNombre("", new GeoPlanJObjet[0], GeoPlanJObjet.Normal, GeoPlanJNombre.Numerique, fig);
	    ((GeoPlanJNombre)tmpObj[0]).valeur = fig.Xmax - Math.random()*(fig.Xmax - fig.Xmin);
	    tmpObj[1] = new GeoPlanJNombre("", new GeoPlanJObjet[0], GeoPlanJObjet.Normal, GeoPlanJNombre.Numerique, fig);
	    ((GeoPlanJNombre)tmpObj[1]).valeur = fig.Ymax - Math.random()*(fig.Xmax - fig.Xmin);
	    tmpObj[2] = fig.roxy;
	    GeoPlanJObjet obj = fig.ajouteObjet(new GeoPlanJPoint(M, tmpObj, GeoPlanJPoint.Normal, 2, fig, 0));// param = 2 car 2 liberts
	    ((GeoPlanJPoint)obj).particularitesParDefaut();
	    if(fig.objetLibreActifAuClavier == null) {
		fig.objetLibreActifAuClavier = obj;
	    }
	    points = points.substring(M.length(), points.length());
	}
	return;
    }
    String point(String chaine) {
	char c = chaine.charAt(0);
	if((c == '\'') || (c == '"')) {
	    return null;
	}
	int i = 1;
	try {
	    c = chaine.charAt(i);
	    if((c == '\'') || (c == '"')) {
		i++;
		c = chaine.charAt(i);
	    }
	    while((c >= '0') && (c <= '9')) {
		i++;
		c = chaine.charAt(i);
	    }
	} catch(Exception e) {
	    /*dpassement de la longueur de la chaine*/
	}
	return chaine.substring(0, i);
    }
}
