import java.awt.Graphics;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Image;
import java.util.StringTokenizer;
import java.awt.Font;
import java.text.NumberFormat;
//import java.util.Locale;

class GeoPlanJFigure {
    Image[] offscreen;
    // offscreen[0] pour l'image normale
    // offscreen[1] pour les affichages
    // offscreen[2] pour les traces
    // ensuite on pourra avoir, ventuellement des offscreen pour les cadres
    Graphics[] offgraph;// les offgraphs correspondant aux offscreen
    double Xmin;
    double Xmax;
    double Ymax;
    double Ymin;//est egale a Ymax - Xmax + Xmin, mais sert a la place de Ymax
    // a cause de la possible zone des affichages
    int hauteurDesAffichages = 0;
    FontMetrics metriqueDeFontes;
    NumberFormat formatDeNombre;
    Color couleurDeFond = Color.white;
    GeoPlanJObjet objetLibreActifAuClavier = null;
    GeoPlanJNombre uniteParDefaut;
    GeoPlanJNombre variableMuette;
    GeoPlanJNombre time;
    GeoPlanJNombre hauteur;
    GeoPlanJNombre largeur;
    GeoPlanJNombre zero;
    GeoPlanJNombre un;
    GeoPlanJNombre uoxy;
    GeoPlanJPoint o;
    GeoPlanJVecteur vecI;
    GeoPlanJVecteur vecJ;
    GeoPlanJRepere roxy;
    GeoPlanJObjet dernier;
    GeoPlanJObjet[] prototypes = {};// des embranchements sur la figure pour les prototypes
    double zoom = 1.25;
    int traceActive;
    public GeoPlanJFigure() {
	//on commence par quelques outils de formatage
	formatDeNombre = NumberFormat.getInstance();//pour imposer la localisation, on aurait pu utiliser NumberFormat.getInstance(Locale.FRENCH) par exemple
	formatDeNombre.setMaximumFractionDigits(6);//les nombres infrieurs  0,000001 sont 0.
	formatDeNombre.setGroupingUsed(true);//pour crire les sparateurs de milliers
	/***************************************************************
	 * on cree les objets par defaut que possede toute figure
	 ***************************************************************/
	variableMuette = new GeoPlanJNombre("variable muette", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);// sert de variable pour les fonctions de rfrence
	time = new GeoPlanJNombre("time", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);
	variableMuette.suivant = time;
	hauteur = new GeoPlanJNombre("hauteur", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);
	hauteur.valeur = 300; // valeur par dfaut
	time.suivant = hauteur;
	largeur = new GeoPlanJNombre("largeur", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);
	largeur.valeur = 300; // valeur par dfaut
	hauteur.suivant = largeur;
	zero = new GeoPlanJNombre("0", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);
	zero.valeur = 0;
	largeur.suivant = zero;
	un = new GeoPlanJNombre("1", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);
	un.valeur = 0;
	zero.suivant = un;
	uoxy = new GeoPlanJNombre("Uoxy", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);//nombre de pixels par unite
	uoxy.valeur = 1;//min(largeur, hauteur)/(Xmax-Xmin)
	un.suivant = uoxy;
	uniteParDefaut = uoxy;
	GeoPlanJObjet[] antecedents = new GeoPlanJObjet[2];
	antecedents[0] = zero;
	antecedents[1] = uoxy;
	GeoPlanJNombre moinsUoxy = new GeoPlanJNombre("-Uoxy", antecedents, GeoPlanJNombre.Normal, GeoPlanJNombre.Soustraction, this);
	uoxy.suivant = moinsUoxy;
	GeoPlanJNombre x0 = new GeoPlanJNombre("x0", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);//-Xmin*Uoxy + max(0, largeur-hauteur)/2
	GeoPlanJNombre y0 = new GeoPlanJNombre("y0", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);//Ymax*Uoxy + max(0, hauteur-largeur)/2
	antecedents = new GeoPlanJObjet[2];
	antecedents[0] = x0;
	antecedents[1] = y0;
	o = new GeoPlanJPoint("o", antecedents, GeoPlanJPoint.Normal, 0, this, 0);
	o.epaisseur = 0;
	o.positionDuNom = 0;
	moinsUoxy.suivant = o;
	antecedents = new GeoPlanJObjet[2];
	antecedents[0] = uoxy;
	antecedents[1] = zero;
	vecI = new GeoPlanJVecteur("vec(i)", antecedents, GeoPlanJVecteur.Normal, GeoPlanJVecteur.Numerique, this);
	o.suivant = vecI;
	antecedents = new GeoPlanJObjet[2];
	antecedents[0] = zero;
	antecedents[1] = moinsUoxy;
	vecJ = new GeoPlanJVecteur("vec(j)", antecedents, GeoPlanJVecteur.Normal, GeoPlanJVecteur.Numerique, this);
	vecI.suivant = vecJ;
	antecedents = new GeoPlanJObjet[2];
	antecedents[0] = o;
	antecedents[1] = vecI;
	GeoPlanJDroite ox = new GeoPlanJDroite("ox", antecedents, GeoPlanJDroite.Normal, GeoPlanJDroite.Parallele, this, 0);
	ox.epaisseur = 0;
	vecJ.suivant = ox;
	antecedents = new GeoPlanJObjet[2];
	antecedents[0] = o;
	antecedents[1] = vecJ;
	GeoPlanJDroite oy = new GeoPlanJDroite("oy", antecedents, GeoPlanJDroite.Normal, GeoPlanJDroite.Parallele, this, 0);
	oy.epaisseur = 0;
	ox.suivant = oy;
	GeoPlanJNombre pi = new GeoPlanJNombre("pi", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);
	pi.valeur = Math.PI;
	oy.suivant = pi;
	GeoPlanJNombre degre = new GeoPlanJNombre("degr", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);
	degre.valeur = Math.PI/180;
	pi.suivant = degre;
	GeoPlanJNombre radian = new GeoPlanJNombre("radian", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);
	radian.valeur = 1;
	degre.suivant = radian;
	antecedents = new GeoPlanJObjet[0];
	GeoPlanJObjet[] variables = new GeoPlanJObjet[1];
	variables[0] = variableMuette;
	GeoPlanJFonction abs = new GeoPlanJFonction("abs", antecedents, variables, GeoPlanJObjet.Normal, GeoPlanJFonction.ValeurAbsolue, this);
	radian.suivant = abs;
	GeoPlanJFonction partieEntiere = new GeoPlanJFonction("int", antecedents, variables, GeoPlanJObjet.Normal, GeoPlanJFonction.PartieEntiere, this);
	abs.suivant = partieEntiere;
	GeoPlanJFonction cos = new GeoPlanJFonction("cos", antecedents, variables, GeoPlanJObjet.Normal, GeoPlanJFonction.Cosinus, this);
	partieEntiere.suivant = cos;
	GeoPlanJFonction sin = new GeoPlanJFonction("sin", antecedents, variables, GeoPlanJFonction.Normal, GeoPlanJFonction.Sinus, this);
	cos.suivant = sin;
	GeoPlanJFonction tan = new GeoPlanJFonction("tan", antecedents, variables, GeoPlanJFonction.Normal, GeoPlanJFonction.Tangente, this);
	sin.suivant = tan;
	GeoPlanJFonction cotan = new GeoPlanJFonction("cotan", antecedents, variables, GeoPlanJFonction.Normal, GeoPlanJFonction.Cotangente, this);
	tan.suivant = cotan;
	GeoPlanJFonction ln = new GeoPlanJFonction("ln", antecedents, variables, GeoPlanJFonction.Normal, GeoPlanJFonction.LogarithmeNeperien, this);
	cotan.suivant = ln;
	GeoPlanJFonction log = new GeoPlanJFonction("log", antecedents, variables, GeoPlanJFonction.Normal, GeoPlanJFonction.LogarithmeDecimal, this);
	ln.suivant = log;
	GeoPlanJFonction exp = new GeoPlanJFonction("exp", antecedents, variables, GeoPlanJFonction.Normal, GeoPlanJFonction.Exponentielle, this);
	log.suivant = exp;
	GeoPlanJFonction racine = new GeoPlanJFonction("rac", antecedents, variables, GeoPlanJFonction.Normal, GeoPlanJFonction.RacineCarree, this);
	exp.suivant = racine;
	antecedents = new GeoPlanJObjet[5];
	antecedents[0] = o;
	antecedents[1] = vecI;
	antecedents[2] = vecJ;
	GeoPlanJNombre un = new GeoPlanJNombre("1", new GeoPlanJObjet[0], GeoPlanJNombre.Normal, GeoPlanJNombre.Numerique, this);
	un.valeur = 1;
	antecedents[3] = un;
	antecedents[4] = un;
	roxy = new GeoPlanJRepere("Roxy", antecedents, GeoPlanJRepere.Normal, 0, this, 0);
	racine.suivant = roxy;
	//roxy.ax = 
	// diff = largeur - hauteur
	// Xmin = Xm - ( Math.abs(diff) + diff ) / 4
	// Xmax = XM + ( Math.abs(diff) + diff ) / 4
	// Ymin = YM - XM + Xm - ( Math.abs(diff) - diff ) / 4
	// Ymax = YM + ( Math.abs(diff) - diff ) / 4
	// donc :
	// Xmax - Xmin = XM - Xm + ( Math.abs(diff) + diff ) / 2
	// Ymax - Ymin = XM - Xm + ( Math.abs(diff) - diff ) / 2
	// 0 -> Xmin
	// 1 -> Xmax en abscisse
	// 0 -> Ymax
	// 1 -> Ymin   en ordonnee
	// X = ( Xmax - Xmin ) * x +        0        * y + Xmin
	// Y =        0        * x - ( Ymax - Ymin ) * y + Ymax
	dernier = roxy;
    }
    //void dessine(Graphics g, Graphics gAff, int hAff) {
    void dessine() {
	//GeoPlanJObjet temp = time;// est-on oblig de commencer si haut dans la chaine ?
	GeoPlanJObjet temp = roxy.suivant;
	while(temp != null) {
	    temp.miseAJour();
	    temp = temp.suivant;
	}
	temp = roxy;
	while(temp != null) {
	    temp.dessine();
	    temp = temp.suivant;
	}
    }
    /**
     *	on agrandit
     */
    public void zoomIn() {
	if(uoxy.valeur < 0.0001) {
	    return;//maximum 0,0001 (1E-4) pour 1 million sur 100 pixels
	}
	// X0 = -Xmin*Uoxy + max(0, largeur-hauteur)/2
	// Y0 = Ymax*Uoxy + max(0, hauteur-largeur)/2
	double XCentre = (largeur.valeur/2 - ((GeoPlanJNombre)o.antecedents[0]).valeur) / uoxy.valeur;
	double YCentre = (hauteur.valeur/2 - ((GeoPlanJNombre)o.antecedents[1]).valeur) / uoxy.valeur;
	Xmin = (Xmin - XCentre) / zoom + XCentre;
	Xmax = (Xmax - XCentre) / zoom + XCentre;
	Ymax = (Ymax - YCentre) / zoom + YCentre;
	uoxy.valeur = uoxy.valeur / zoom;
	((GeoPlanJNombre)o.antecedents[0]).valeur = (((GeoPlanJNombre)o.antecedents[0]).valeur - largeur.valeur/2) / zoom + largeur.valeur/2;
	((GeoPlanJNombre)o.antecedents[1]).valeur = (((GeoPlanJNombre)o.antecedents[1]).valeur - hauteur.valeur/2) / zoom + hauteur.valeur/2;
	o.miseAJour();
	uoxy.suivant.miseAJour();
	vecI.miseAJour();
	vecJ.miseAJour();
	vecJ.suivant.miseAJour();
	vecJ.suivant.suivant.miseAJour();
	roxy.miseAJour();
    }
    /**
     *	on rduit
     */
    public void zoomOut() {
	//uoxy reprsente le nombre de pixels par unit
	if(uoxy.valeur > 10000000) {
	    return;//maximum 10 000 000 pour 0,00001 sur 100 pixels
	}
	double XCentre = (largeur.valeur/2 - ((GeoPlanJNombre)o.antecedents[0]).valeur) / uoxy.valeur;
	double YCentre = (hauteur.valeur/2 - ((GeoPlanJNombre)o.antecedents[1]).valeur) / uoxy.valeur;
	Xmin = (Xmin - XCentre) * zoom + XCentre;
	Xmax = (Xmax - XCentre) * zoom + XCentre;
	Ymax = (Ymax - YCentre) * zoom + YCentre;
	uoxy.valeur = uoxy.valeur * zoom;
	((GeoPlanJNombre)o.antecedents[0]).valeur = (((GeoPlanJNombre)o.antecedents[0]).valeur - largeur.valeur/2) * zoom + largeur.valeur/2;
	((GeoPlanJNombre)o.antecedents[1]).valeur = (((GeoPlanJNombre)o.antecedents[1]).valeur - hauteur.valeur/2) * zoom + hauteur.valeur/2;
	o.miseAJour();
	uoxy.suivant.miseAJour();
	vecI.miseAJour();
	vecJ.miseAJour();
	vecJ.suivant.miseAJour();
	vecJ.suivant.suivant.miseAJour();
	roxy.miseAJour();
    }
    /**
     *	la procedure "ajouteObjet(nouveau)" fait pointer la variable
     *	suivant du dernier objet cr sur nouveau
     *	et modifie en consquence la valeur de dernier de roxy
     */
    public GeoPlanJObjet ajouteObjet(GeoPlanJObjet nouveau) {
	if(nouveau == null) {
	    return(null);
	}// cette procdure est devenue necessaire  cause du chainage des fonctions
	// c'est--dire  cause de "figure.ajouteObjet(modeliser(4, figure), false)" par exemple
	if(nouveau.nom == "") {
	    dernier.suivant = nouveau;
	    dernier = nouveau;
	    return(nouveau);
	}
	GeoPlanJObjet temp = objetNomme(nouveau.nom);
	if(temp == null) {
	    dernier.suivant = nouveau;
	    dernier = nouveau;
	    return(nouveau);
	} else {// redefinition
	    if(nouveau.type != temp.type) {
        	return(null);
	    } else {
		return(temp);
	    }
	}
    }
    /**
     *	la procedure "ajouteOuRedefinitObjet(nouveau)" fait pointer la variable
     *	suivant du dernier objet cr sur nouveau
     *	et modifie en consquence la valeur de dernier de roxy
     *  elle redfinit l'objet prcdemment existant
     */
    public GeoPlanJObjet ajouteOuRedefinitObjet(GeoPlanJObjet nouveau) {
	if(nouveau.nom == "") {
	    dernier.suivant = nouveau;
	    dernier = nouveau;
	    return(nouveau);
	}
	GeoPlanJObjet temp = objetNomme(nouveau.nom);
	if(temp == null) {
	    dernier.suivant = nouveau;
	    dernier = nouveau;
	    return(nouveau);
	} else {// redefinition
	    if(nouveau.type != temp.type) {//on change de type d'objet, donc, on efface toute sa descendance
        	return(temp);
	    } else {//le nouvel objet ne doit pas dpendre des descendants de celui qu'il remplace
		return(temp);
	    }
	}
    }
    /**
     *	la procedure "objetNomme(nom)" renvoie l'objet dont
     *	le nom est "nom", si elle le trouve dans la descendance
     *	de l'objet courant ; elle renvoie null sinon.
     */
    public GeoPlanJObjet objetNomme(String nom) {
	GeoPlanJObjet temp = variableMuette;
	while(!temp.nom.equals(nom)) {
	    temp = temp.suivant;
	    if(temp == null) {
		return null;
	    }
	}
	while(temp.suivant != null && temp.suivant.nom.equals(nom)) {
	    temp = temp.suivant;
	}
	return temp;
    }
    /**
     *	la procedure "chercheLibre(x, y)" renvoie le premier objet
     *	libre dont les coordonnes sont gales  x et y  3 pixels prs.
     *	Elle renvoie null si aucun objet ne vrifie ces conditions.
     */
    public GeoPlanJObjet chercheLibre(int ciblex, int cibley) {
	GeoPlanJObjet temp = roxy.suivant;
	while(temp != null) {
	    if(temp.type == GeoPlanJObjet.Point) {
		if(((GeoPlanJPoint)temp).param > 0) {
		    if(Math.abs(((GeoPlanJPoint)temp).x - ciblex)<3 && Math.abs(((GeoPlanJPoint)temp).y - cibley)<3 ) {
			return temp;
		    }
		}
	    }
	    temp = temp.suivant;
	}
	return null;
    }
    public int nouveauPrototype(GeoPlanJObjet precedent) {
	//System.out.println("nouveauPrototype");
	if(prototypes.length == 0) {
	    prototypes = new GeoPlanJObjet[1];
	} else {
	    GeoPlanJObjet[] temp = new GeoPlanJObjet[prototypes.length+1];
	    System.arraycopy(prototypes, 0, temp, 0, prototypes.length);
	    prototypes = temp;
	}
	prototypes[prototypes.length-1] = precedent.suivant;
	precedent.suivant = null;
	dernier = precedent;
	// pour debug
	for(int i=0; i<prototypes.length; i++) {
	    //System.out.println("le prototype commence par " + prototypes[i].nom);
	    GeoPlanJObjet tempObj = prototypes[i];
	    while(tempObj.suivant != null) {
		tempObj = tempObj.suivant;
	    }
	    //System.out.println("et se termine par " + tempObj.nom);
	}
	// fin de debug
	return(0);
    }
    public Color couleurNommee(String nomDeLaCouleur) {
	if("couleur du fond".equals(nomDeLaCouleur)) {
	    return(couleurDeFond);
	} else if("gris".equals(nomDeLaCouleur)) {
	    return(Color.lightGray);
	} else if("gris fonc".equals(nomDeLaCouleur)) {
	    return(Color.lightGray.darker());
	} else if("rose".equals(nomDeLaCouleur)) {
	    return(Color.pink);
	} else if("rose fonc".equals(nomDeLaCouleur)) {
	    return(Color.pink.darker());
	} else if("rouge".equals(nomDeLaCouleur)) {
	    return(Color.red);
	} else if("rouge fonc".equals(nomDeLaCouleur)) {
	    return(Color.red.darker());
	} else if("ciel".equals(nomDeLaCouleur)) {
	    return(Color.cyan);
	} else if("ciel fonc".equals(nomDeLaCouleur)) {
	    return(Color.cyan.darker());
	} else if("bleu".equals(nomDeLaCouleur)) {
	    return(Color.blue);
	} else if("bleu fonc".equals(nomDeLaCouleur)) {
	    return(Color.blue.darker());
	} else if("jaune".equals(nomDeLaCouleur)) {
	    return(Color.yellow);
	} else if("jaune fonc".equals(nomDeLaCouleur)) {
	    return(Color.yellow.darker());
	} else if("vert".equals(nomDeLaCouleur)) {
	    return(Color.green);
	} else if("vert fonc".equals(nomDeLaCouleur)) {
	    return(Color.green.darker());
	} else if("blanc".equals(nomDeLaCouleur)) {
	    return(Color.white);
	} else if("noir".equals(nomDeLaCouleur)) {
	    return(Color.black);
	} else if(nomDeLaCouleur.length() > 8 && "couleur(".equals(nomDeLaCouleur.substring(0, 8)) && nomDeLaCouleur.charAt(nomDeLaCouleur.length()-1) == ')') {
	    StringTokenizer st = new StringTokenizer(nomDeLaCouleur.substring(8, nomDeLaCouleur.length() - 1), ";");
	    int rouge = 0;
	    int vert = 0;
	    int bleu = 0;
	    int alpha = 255;//par dfaut alpha au max
	    if(st.hasMoreTokens()) {
		try {
		    rouge = (new Integer(st.nextToken())).intValue();
		} catch(Exception e) {
		    //System.out.println("Erreur dans la couleur rouge : ce n'est pas un nombre");
		    return(null);
		}
		if(st.hasMoreTokens()) {
		    try {
			vert = (new Integer(st.nextToken())).intValue();
		    } catch(Exception e) {
			System.out.println("Erreur dans la couleur verte : ce n'est pas un nombre");
			return(null);
		    }
		    if(st.hasMoreTokens()) {
			try {
			    bleu = (new Integer(st.nextToken())).intValue();
			} catch(Exception e) {
			    System.out.println("Erreur dans la couleur bleue : ce n'est pas un nombre");
			    return(null);
			}
			if(st.hasMoreTokens()) {
			    try {
				alpha = (new Integer(st.nextToken())).intValue();
			    } catch(Exception e) {
				System.out.println("Erreur dans la couleur bleue : ce n'est pas un nombre");
				return(null);
			    }
			}
		    }
		}
	    }
	    if(rouge < 0 || rouge > 255 || vert < 0 || vert > 255 || bleu < 0 || bleu > 255 || alpha < 0 || alpha > 255) {
		System.out.println("les coefficients de couleur doivent tre entre 0 et 255");
		return(null);
	    }
	    Color couleur = null;
	    if(System.getProperty("java.version").substring(0,3).equals("1.1") || alpha == 255) {
		couleur = new Color(rouge, vert, bleu);
	    } else {
		couleur = new Color(rouge, vert, bleu, alpha);
	    }
	    return(couleur);
	} else {
	    return(null);
	}
    }
}
