import java.awt.Graphics;
import java.awt.Color;
import java.lang.Math;

class GeoPlanJFonction extends GeoPlanJObjet {
    public static final int Fonction = 0;//cas general
    public static final int Cosinus = 1;
    public static final int Sinus = 2;
    public static final int Tangente = 3;
    public static final int Cotangente = 4;
    public static final int LogarithmeNeperien = 5;
    public static final int LogarithmeDecimal = 6;
    public static final int Exponentielle = 7;
    public static final int RacineCarree = 8;
    public static final int ValeurAbsolue = 9;
    public static final int PartieEntiere = 10;
    public static final int SuiteRecurrente = 11;

    GeoPlanJObjet[] variables = {};
    GeoPlanJFonction(String nom, GeoPlanJObjet[] antecedents, GeoPlanJObjet[] variables, int sousType, int param, GeoPlanJFigure figure) {
	this.nom = nom;
	this.type = GeoPlanJObjet.Fonction;
	this.antecedents = antecedents;
	this.variables = variables;
	this.sousType = sousType;
	this.param = param;
	this.figure = figure;
    }
    void initialise() {
	//a faire
	//c'est une initialisation avant de calculer des valeurs
	//effectuer par la courbe
	//
	// mais c'est peut-tre inutile, car dans un premier temps, au moins,
	// les initialisations vont tre faites en mme temps que le calcul des 
	// valeurs de la fonction...
    }
    /**
     *  la fonction valeurPour permet de calculer la valeur des fonctions
     */
    double valeurPour(GeoPlanJObjet[] variables) {
	switch(sousType) {
	case Normal:
	case Donne:
	    switch(param) {
	    case Cosinus:
		if(variables.length != 1 || variables[0].type != GeoPlanJObjet.Nombre) {
		    return(Double.NaN);// pour Not a Number, qui nous servira pour valeur indtermine
		} else {
		    return(Math.cos(((GeoPlanJNombre)variables[0]).valeur));
		}
	    case Sinus:
		if(variables.length != 1 || variables[0].type != GeoPlanJObjet.Nombre) {
		    return(Double.NaN);// pour Not a Number, qui nous servira pour valeur indtermine
		} else {
		    return(Math.sin(((GeoPlanJNombre)variables[0]).valeur));
		}
	    case Tangente:
		if(variables.length != 1 || variables[0].type != GeoPlanJObjet.Nombre) {
		    return(Double.NaN);// pour Not a Number, qui nous servira pour valeur indtermine
		} else {
		    return(Math.tan(((GeoPlanJNombre)variables[0]).valeur));
		}
	    case Cotangente:
		if(variables.length != 1 || variables[0].type != GeoPlanJObjet.Nombre) {
		    return(Double.NaN);// pour Not a Number, qui nous servira pour valeur indtermine
		} else {
		    return(1/Math.tan(((GeoPlanJNombre)variables[0]).valeur));
		}
	    case LogarithmeNeperien:
		if(variables.length != 1 || variables[0].type != GeoPlanJObjet.Nombre) {
		    return(Double.NaN);// pour Not a Number, qui nous servira pour valeur indtermine
		} else {
		    return(Math.log(((GeoPlanJNombre)variables[0]).valeur));
		}
	    case LogarithmeDecimal:
		if(variables.length != 1 || variables[0].type != GeoPlanJObjet.Nombre) {
		    return(Double.NaN);// pour Not a Number, qui nous servira pour valeur indtermine
		} else {
		    return(Math.log(((GeoPlanJNombre)variables[0]).valeur)/Math.log(10));
		}
	    case Exponentielle:
		if(variables.length != 1 || variables[0].type != GeoPlanJObjet.Nombre) {
		    return(Double.NaN);// pour Not a Number, qui nous servira pour valeur indtermine
		} else {
		    return(Math.exp(((GeoPlanJNombre)variables[0]).valeur));
		}
	    case RacineCarree:
		if(variables.length != 1 || variables[0].type != GeoPlanJObjet.Nombre) {
		    return(Double.NaN);// pour Not a Number, qui nous servira pour valeur indtermine
		} else {
		    return(Math.sqrt(((GeoPlanJNombre)variables[0]).valeur));
		}
	    case ValeurAbsolue:
		if(variables.length != 1 || variables[0].type != GeoPlanJObjet.Nombre) {
		    return(Double.NaN);// pour Not a Number, qui nous servira pour valeur indtermine
		} else {
		    return(Math.abs(((GeoPlanJNombre)variables[0]).valeur));
		}
	    case PartieEntiere:
		if(variables.length != 1 || variables[0].type != GeoPlanJObjet.Nombre) {
		    return(Double.NaN);// pour Not a Number, qui nous servira pour valeur indtermine
		} else {
		    return(Math.floor(((GeoPlanJNombre)variables[0]).valeur));
		}
	    default:
		// cas de la fonction qui est elle mme un prototype
		// pour debug
		if(param >= 0 || (figure.prototypes.length + param) < 0) {
		    System.out.println("Erreur : fonction inconnue (hors limite)");
		    System.out.println("prototypes.length = " + Integer.toString(figure.prototypes.length));
		    System.out.println("param = " + Integer.toString(param));
		    return(Double.NaN);
		}
		// fin de debug
		//System.out.println("la fonction se nomme " + this.nom);
		//System.out.println("elle a " + Integer.toString(antecedents.length) + " antcdents");
		//System.out.println("et elle a " + Integer.toString(this.variables.length) + " variables");
		GeoPlanJObjet tmp2 = figure.prototypes[-param-1];
		int numeroAntecedent = 0;
		int numeroVariable = 0;
		while(tmp2.suivant != null) {
		    switch(tmp2.sousType) {
		    case Donne:
			if(numeroAntecedent < antecedents.length && tmp2.copie(antecedents[numeroAntecedent]) == 0) {
			    //System.out.println("tmp2.nom = " + tmp2.nom);
			    //System.out.println("antecedent.nom = " + antecedents[numeroAntecedent].nom);
			    tmp2 = tmp2.suivant;
			    numeroAntecedent++;
			} else {
			    System.out.println("Erreur dans les antecedents de la fonction " + nom);
			    return(Double.NaN);
			}
			break;
		    case Variable:
			if(numeroVariable < variables.length && tmp2.copie(variables[numeroVariable]) == 0) {
			    //System.out.println("tmp2.nom = " + tmp2.nom);
			    //System.out.println("variable.nom = " + variables[numeroVariable].nom);
			    tmp2 = tmp2.suivant;
			    numeroVariable++;
			} else {
			    System.out.println("Erreur dans les variables de la fonction " + nom);
			    return(Double.NaN);
			}
			break;
		    default:
			tmp2.miseAJour();
			tmp2 = tmp2.suivant;
		    }
		}
		if(numeroAntecedent != antecedents.length) {
		    System.out.println("Erreur dans le nombre d'antecedents de la fonction " + nom);
		    System.out.println("numeroAntecedent = " + numeroAntecedent);
		    System.out.println("antecedents.length = " + antecedents.length);
		    System.out.println("antecedents[0] = " + antecedents[0].nom);
		    return(Double.NaN);
		}
		if(numeroVariable != variables.length) {
		    System.out.println("Erreur dans le nombre de variables de la fonction " + nom);
		    return(Double.NaN);
		}
		tmp2.miseAJour();
		if(tmp2.type == GeoPlanJObjet.Nombre && !tmp2.HS) {
		    return(((GeoPlanJNombre)tmp2).valeur);
		} else {
		    return(Double.NaN);
		}
	    }
	case SuiteRecurrente:
	    //une suite ne peut tre qu' une seule variable
	    //System.out.println("suite rcurrente");
	    if(variables.length != 1 || variables[0].type != GeoPlanJObjet.Nombre) {
		return(Double.NaN);// pour Not a Number, qui nous servira pour valeur indtermine
	    }
	    // pour debug
	    if(param >= 0 || (figure.prototypes.length + param) < 0) {
		System.out.println("Erreur : suite inconnue (hors limite)");
		System.out.println("prototypes.length = " + Integer.toString(figure.prototypes.length));
		System.out.println("param = " + Integer.toString(param));
		return(Double.NaN);
	    }
	    // fin de debug
	    //System.out.println("ici");
	    GeoPlanJNombre[] tmp = new GeoPlanJNombre[antecedents.length];
	    tmp[0] = (GeoPlanJNombre)figure.prototypes[-param-1];
	    for(int i = 1 ; i < antecedents.length ; i++) {
		tmp[i] = (GeoPlanJNombre)tmp[i-1].suivant;
	    }
	    //System.out.println("le nom de n est " + tmp[antecedents.length - 1].nom);
	    if(((GeoPlanJNombre)variables[0]).valeur < ((GeoPlanJNombre)antecedents[antecedents.length - 1]).valeur + antecedents.length - 1) {
		if(((GeoPlanJNombre)variables[0]).valeur < ((GeoPlanJNombre)antecedents[antecedents.length - 1]).valeur) {
		    return(Double.NaN);//on demande une valeur hors domaine
		} else {
		    //System.out.println("valeur prdfine " + this.nom + "(" + (int)((GeoPlanJNombre)variables[0]).valeur + ")=" + ((GeoPlanJNombre)antecedents[(int)(((GeoPlanJNombre)variables[0]).valeur - ((GeoPlanJNombre)antecedents[antecedents.length - 1]).valeur)]).valeur);
		    return(((GeoPlanJNombre)antecedents[(int)(((GeoPlanJNombre)variables[0]).valeur - ((GeoPlanJNombre)antecedents[antecedents.length - 1]).valeur)]).valeur);
		}
	    }
	    if(((GeoPlanJNombre)variables[0]).valeur < tmp[antecedents.length - 1].valeur){// on reinitialise
		//System.out.println("reinit");
		for(int i = 0 ; i < antecedents.length - 1; i++) {
		    tmp[i].valeur = ((GeoPlanJNombre)antecedents[i]).valeur;
		    tmp[i].HS = false;
		}
		tmp[antecedents.length - 1].valeur = ((GeoPlanJNombre)antecedents[antecedents.length - 1]).valeur + antecedents.length - 1;// n pointe sur la prochaine valeur  calculer
		tmp[antecedents.length - 1].HS = false;
	    }
	    /*
	    if(((GeoPlanJNombre)variables[0]).valeur == tmp[antecedents.length - 1].valeur) {
		System.out.println("la valeur de la suite est " + tmp[antecedents.length - 2].valeur);
		System.out.println(this.nom + "(" + (int)((GeoPlanJNombre)variables[0]).valeur + ")=" + tmp[antecedents.length - 2].valeur);
		return(tmp[antecedents.length - 2].valeur);
	    }
	    if(((GeoPlanJNombre)variables[0]).valeur < tmp[antecedents.length - 1].valeur) {
		return(Double.NaN);//on demande une valeur hors domaine
	    }
	    */
	    while(((GeoPlanJNombre)variables[0]).valeur >= tmp[antecedents.length - 1].valeur) {
		GeoPlanJObjet temp = tmp[antecedents.length - 1].suivant;
		while(temp.suivant != null) {
		    temp.miseAJour();
		    temp = temp.suivant;
		}
		temp.miseAJour();
		for(int i = 0 ; i < antecedents.length - 2 ; i++) {
		    tmp[i].valeur = tmp[i+1].valeur;
		}
		tmp[antecedents.length - 1].valeur++;
		if(temp.type == GeoPlanJObjet.Nombre && !temp.HS) {
		    tmp[antecedents.length - 2].valeur = ((GeoPlanJNombre)temp).valeur;
		} else {
		    tmp[antecedents.length - 2].HS = true;
		}
	    }
	    if(!tmp[antecedents.length - 2].HS) {
		//System.out.println(this.nom + "(" + (int)((GeoPlanJNombre)variables[0]).valeur + ")=" + tmp[antecedents.length - 2].valeur);
		return(tmp[antecedents.length - 2].valeur);
	    } else {
		return(Double.NaN);
	    }
	default:
	    //cas des Prototypes
	    //System.out.println("la fonction prototype s'appelle " + this.nom);
	    GeoPlanJObjet proto = miseAJourPrototype();
	    //System.out.println("miseAJourPrototype renvoie l'objet " + proto.nom);
	    if(proto == null) {
		return(Double.NaN);
	    }
	    //System.out.println("prototype mis  jour");
	    //System.out.println("la fonction retourne par le prototype s'appelle " + tmp2.nom);
	    return(((GeoPlanJFonction)proto).valeurPour(variables));
	}
    }
    void miseAJour() {
	for(int i = 0 ; i < antecedents.length ; i++) {
	    if(antecedents[i].HS) {
		this.HS = true;
		return;
	    }
	}
	switch(sousType) {
	default:
	    //cas des Prototypes
	    GeoPlanJObjet proto = miseAJourPrototype();
	    //System.out.println("miseAJourPrototype renvoie l'objet " + proto.nom);
	    //System.out.println(" de params : " + ((GeoPlanJPoint)proto).x + ", " + ((GeoPlanJPoint)proto).y);
	    if(proto == null) {
		HS = true;
		return;
	    }
	    HS = false;
	    return;
	case Normal:
	    HS = false;
	    return;
	}
    }
    int copie(GeoPlanJObjet obj) {
	if(obj.type == GeoPlanJObjet.Fonction) {
	    if(obj.sousType < 0) {// c'est un prototype
		obj = obj.miseAJourPrototype();
	    }
	    this.antecedents = ((GeoPlanJFonction)obj).antecedents;
	    this.variables = ((GeoPlanJFonction)obj).variables;
	    this.param = ((GeoPlanJFonction)obj).param;
	    return(0);
	} else {
	    System.out.println("Erreur : tentative de copier un objet de mauvais type");
	    return(-1);
	}
    }
}
