import java.awt.Graphics;
import java.awt.Color;
import java.lang.Math;

class GeoPlanJNombre extends GeoPlanJObjet {
    public static final int NonDefini = -1;
    public static final int Numerique = 0;
    public static final int Distance = 1;//Norme pour un vecteur
    public static final int Addition = 2;
    public static final int Soustraction = 3;
    public static final int Multiplication = 4;
    public static final int Division = 5;
    public static final int Puissance = 6;
    public static final int Fonction= 7;
    public static final int Transformation = 8;
    public static final int Rayon = 9;
    //
    public static final int Minimum = 10;
    public static final int Maximum = 11;
    //
    public static final int Abscisse = 12;
    public static final int Ordonnee = 13;
    //
    public static final int Copie = 100;//juste la copie d'un autre nombre avec seulement un nom diffrent
    // les oprations purement boolennes
    //public static final int Boolean = 100;
    public static final int Et = 101;
    public static final int Ou = 102;
    public static final int OuEx = 103;// (?)
    public static final int Non = 104;
    // oprations donnant des boolens
    // attention : codage spcial des boolens
    // 0 pour faux, le reste est vrai
    // mais avec une prfrence pour la valeur 1
    // ceci pour tre compatible avec la fonction  de GoplanW
    public static final int Egal = 105;
    public static final int Different = 106;
    public static final int Inferieur = 107;
    public static final int InferieurOuEgal = 108;
    public static final int Superieur = 109;
    public static final int SuperieurOuEgal = 110;

    //int sousType;
    double valeur;
    //GeoPlanJObjet objet1 = null;
    //GeoPlanJObjet objet2 = null;
    //GeoPlanJObjet[] tableau;
    //boolean libre;
    /*
    GeoPlanJNombre(String name)
    {
	type = GeoPlanJObjet.Nombre;
	sousType = Numerique;
	HS = false;
	valeur = 0;
	nom = name;
    }
    GeoPlanJNombre(double val)
    {
	type = GeoPlanJObjet.Nombre;
	sousType = Numerique;
	HS = false;
	valeur = val;
	nom = Double.toString(val);
    }
    GeoPlanJNombre(String name, GeoPlanJObjet M, int stype)
    {
	type = GeoPlanJObjet.Nombre;
	sousType = stype;
	HS = false;
	valeur = 0;
	nom = name;
	objet1 = M;
    }
    GeoPlanJNombre(String name, GeoPlanJObjet M, GeoPlanJObjet N, int stype) {
	type = GeoPlanJObjet.Nombre;
	sousType = stype;
	HS = false;
	valeur = 0;
	nom = name;
	objet1 = M;
	objet2 = N;
    }
    GeoPlanJNombre(String name, GeoPlanJObjet f, GeoPlanJObjet[] tableau) {// cas particulier pour les fonctions
	type = GeoPlanJObjet.Nombre;
	sousType = Fonction;
	HS = false;
	valeur = 0;
	nom = name;
	if(f.type != GeoPlanJObjet.Fonction) {
	    System.out.println("l'objet " + f.nom + " n'est pas une fonction");
	    objet1 = null;
	} else {
	    objet1 = f;
	    this.tableau = tableau;
	}
    }
    */
    GeoPlanJNombre(String nom, GeoPlanJObjet[] antecedents, int sousType, int param, GeoPlanJFigure figure) {
	this.nom = nom;
	this.type = GeoPlanJObjet.Nombre;
	this.antecedents = antecedents;
	this.sousType = sousType;
	this.param = param;
	this.figure = figure;
    }
    // dbut des procdures
    GeoPlanJObjet addition(GeoPlanJObjet x) {
	if(x == null || x.type != GeoPlanJObjet.Nombre) {
	    return(null);
	}
	if(x == figure.zero) {
	    return(this);
	}
	if(this == figure.zero) {
	    return(x);
	}
	String n = nom + "+" + x.nom;
	GeoPlanJObjet y = figure.objetNomme(n);
	if(y == null) {
	    GeoPlanJObjet[] antecedents = new GeoPlanJObjet[2];
	    antecedents[0] = this;
	    antecedents[1] = x;
	    y = new GeoPlanJNombre(n, antecedents, GeoPlanJNombre.Normal, Addition, figure);
	    figure.ajouteObjet(y);
	} else if(y.type != GeoPlanJObjet.Nombre) {
	    System.out.println("l'objet existe deja, mais n'est pas un nombre");
	    return(null);
	}
	return(y);
    }
    GeoPlanJObjet soustraction(GeoPlanJObjet x) {
	if(x == null || x.type != GeoPlanJObjet.Nombre) {
	    return(null);
	}
	if(x == figure.zero) {
	    return(this);
	}
	String n = nom + "-" + x.nom;
	GeoPlanJObjet y = figure.objetNomme(n);
	if(y == null) {
	    GeoPlanJObjet[] antecedents = new GeoPlanJObjet[2];
	    antecedents[0] = this;
	    antecedents[1] = x;
	    y = new GeoPlanJNombre(n, antecedents, GeoPlanJNombre.Normal, Soustraction, figure);
	    figure.ajouteObjet(y);
	}
	return(y);
    }
    GeoPlanJObjet multiplication(GeoPlanJObjet x) {
	if(x == null) {
	    return(null);
	}
	if(x == figure.zero || this == figure.zero) {
	    return(figure.zero);
	}
	if(x == figure.un) {
	    return(this);
	}
	if(this == figure.un) {
	    return(x);
	}
	if(x.type == GeoPlanJObjet.Nombre) {
	    String n = nom + "*" + x.nom;
	    GeoPlanJObjet y = figure.objetNomme(n);
	    if(y == null) {
		GeoPlanJObjet[] antecedents = new GeoPlanJObjet[2];
		antecedents[0] = this;
		antecedents[1] = x;
		y = new GeoPlanJNombre(n, antecedents, GeoPlanJNombre.Normal, Multiplication, figure);
		figure.ajouteObjet(y);
	    }
	    return(y);
	} else if(x.type == GeoPlanJObjet.Vecteur) {
	    String n = nom + "*" + x.nom;
	    GeoPlanJObjet y = figure.objetNomme(n);
	    if(y == null) {
		GeoPlanJObjet[] antecedents = new GeoPlanJObjet[2];
		antecedents[0] = this;
		antecedents[1] = x;
		y = new GeoPlanJVecteur(n, antecedents, GeoPlanJNombre.Normal, GeoPlanJVecteur.Multiplication, figure);
		figure.ajouteObjet(y);
	    }
	    return(y);
	} else {
	    return(null);
	}
    }
    GeoPlanJObjet division(GeoPlanJObjet x) {
	if(x == null || x.type != GeoPlanJObjet.Nombre) {
	    return(null);
	}
	if(x == figure.zero) {
	    System.out.println("Erreur : division par zro");
	    return(null);
	}
	if(this == figure.zero) {
	    return(figure.zero);
	}
	if(x == figure.un) {
	    return(this);
	}
	String n = nom + "/" + x.nom;
	GeoPlanJObjet y = figure.objetNomme(n);
	if(y == null) {
	    GeoPlanJObjet[] antecedents = new GeoPlanJObjet[2];
	    antecedents[0] = this;
	    antecedents[1] = x;
	    y = new GeoPlanJNombre(n, antecedents, GeoPlanJNombre.Normal, Division, figure);
	    figure.ajouteObjet(y);
	}
	return(y);
    }
    GeoPlanJObjet puissance(GeoPlanJObjet x) {
	if(x == null || x.type != GeoPlanJObjet.Nombre) {
	    return(null);
	}
	String n = nom + "^" + x.nom;
	GeoPlanJObjet y = figure.objetNomme(n);
	if(y == null) {
	    GeoPlanJObjet[] antecedents = new GeoPlanJObjet[2];
	    antecedents[0] = this;
	    antecedents[1] = x;
	    y = new GeoPlanJNombre(n, antecedents, GeoPlanJNombre.Normal, Puissance, figure);
	    figure.ajouteObjet(y);
	}
	return(y);
    }
    void miseAJour() {
	// on pourrait, ventuellement, faire un pr-test, ici, pour renforcer le pouvoir
	// "nullifiant" d'une fonction  pour faciliter la dfinition des foncitons dfinies par morceaux
	// il reste des cas a faire dans mise a jour comme par exemple,
	// produit scalaire, nombre par vecteur (dans GeoPlanJVecteur) ... etc ...
	for(int i = 0 ; i < antecedents.length ; i++) {
	    if(antecedents[i].HS) {
		this.HS = true;
		return;
	    }
	}
	switch(sousType) {
	default:
	    //cas des Prototypes
	    GeoPlanJObjet proto = miseAJourPrototype();
	    if(proto == null) {
		HS = true;
		return;
	    }
	    this.valeur = ((GeoPlanJNombre)proto).valeur;
	    HS = false;
	    return;
	case Normal:
	    switch(param) {
	    case NonDefini:
		//System.out.println("numerique " + nom + " : " + Double.toString(valeur));
		HS = true;
		break;
	    case Numerique:
		//System.out.println("numerique " + nom + " : " + Double.toString(valeur));
		HS = false;
		break;
	    case Copie:
		//System.out.println("numerique " + nom + " : " + Double.toString(valeur));
		HS = false;
		valeur = ((GeoPlanJNombre)antecedents[0]).valeur;
		break;
	    case Distance:
		switch(antecedents.length) {
		case 2:
		    switch(antecedents[0].type) {
		    case GeoPlanJObjet.Vecteur:
			switch(antecedents[1].type) {
			case GeoPlanJObjet.Repere://norme d'un vecteur dans un repre 
			    HS = false;
			    //a revoir, il faut convertir dans le repere avant de faire le calcul suivant
			    valeur = Math.sqrt(((GeoPlanJVecteur)antecedents[0]).x * ((GeoPlanJVecteur)antecedents[0]).x + ((GeoPlanJVecteur)antecedents[0]).y * ((GeoPlanJVecteur)antecedents[0]).y);
			    break;
			default:
			    System.out.println("Erreur : cas non prvu : distance : vecteur, ?");
			    HS = true;
			    return;
			}
			break;
		    case GeoPlanJObjet.Droite:
			switch(antecedents[1].type) {
			case GeoPlanJObjet.Nombre://longueur d'un segment
			    HS = false;
			    double dx = ((GeoPlanJDroite)antecedents[0]).x0 - ((GeoPlanJDroite)antecedents[0]).x1;
			    double dy = ((GeoPlanJDroite)antecedents[0]).y0 - ((GeoPlanJDroite)antecedents[0]).y1;
			    valeur = Math.sqrt(dx*dx + dy*dy) / ((GeoPlanJNombre)antecedents[1]).valeur;
			    break;
			case GeoPlanJObjet.Repere://coefficient directeur d'une droite dans un repre
			    valeur = (((GeoPlanJRepere)antecedents[1]).ay * (((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0) + ((GeoPlanJRepere)antecedents[1]).by * (((GeoPlanJDroite)antecedents[0]).y1 - ((GeoPlanJDroite)antecedents[0]).y0)) / (((GeoPlanJRepere)antecedents[1]).ax * (((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0) + ((GeoPlanJRepere)antecedents[1]).bx * (((GeoPlanJDroite)antecedents[0]).y1 - ((GeoPlanJDroite)antecedents[0]).y0));
			    if(valeur == Double.NaN) {
				HS = true;
			    } else {
				HS = false;
			    }
			    break;
			default:
			    System.out.println("Erreur : cas non prvu : distance : droite, ?");
			    HS = true;
			    return;
			}
			break;
		    case GeoPlanJObjet.Cercle:
			switch(antecedents[1].type) {
			case GeoPlanJObjet.Nombre://rayon d'un cercle dans une unit de longueur
			    valeur = ((GeoPlanJCercle)antecedents[0]).R / ((GeoPlanJNombre)antecedents[1]).valeur;
			    break;
			default:
			    System.out.println("Erreur : cas non prvu : distance : cercle, ?");
			    HS = true;
			    return;
			}
			break;
		    default:
			System.out.println("Erreur : cas non prvu : distance : ?, ?");
			//System.out.println("les objets sont : " + antecedents[0].nom + " et " + antecedents[1].nom);
			HS = true;
			return;
		    }
		    break;
		case 3: // distance de deux points par rapport  une longueur de rfrence
		    switch(antecedents[0].type) {
		    case GeoPlanJObjet.Point:
			switch(antecedents[1].type) {
			case GeoPlanJObjet.Point:// distance de deux points
			    switch(antecedents[2].type) {
			    case GeoPlanJObjet.Nombre: // unit de longueur
				double dx = ((GeoPlanJPoint)antecedents[0]).x - ((GeoPlanJPoint)antecedents[1]).x;
				double dy = ((GeoPlanJPoint)antecedents[0]).y - ((GeoPlanJPoint)antecedents[1]).y;
				valeur = Math.sqrt(dx * dx + dy * dy) / ((GeoPlanJNombre)antecedents[2]).valeur;
				HS = false;
				break;
			    default:
				System.out.println("Erreur : cas non prvu : distance deux points sans longueur de rfrence");
				HS = true;
				return;
			    }
			    break;
			case GeoPlanJObjet.Droite:
			    switch(antecedents[2].type) {
			    case GeoPlanJObjet.Nombre: //distance d'un point  une droite avec une unit de longueur
				double a = ((GeoPlanJDroite)antecedents[1]).y0 - ((GeoPlanJDroite)antecedents[1]).y1;
				double b = ((GeoPlanJDroite)antecedents[1]).x1 - ((GeoPlanJDroite)antecedents[1]).x0;
				double c = ((GeoPlanJDroite)antecedents[1]).x0 * ((GeoPlanJDroite)antecedents[1]).y1 - ((GeoPlanJDroite)antecedents[1]).x1 * ((GeoPlanJDroite)antecedents[1]).y0;
				valeur = Math.abs(a * ((GeoPlanJPoint)antecedents[0]).x + b * ((GeoPlanJPoint)antecedents[0]).y + c) / (Math.sqrt(a * a + b * b) * ((GeoPlanJNombre)antecedents[2]).valeur);
				HS = false;
				break;
			    default:
				System.out.println("Erreur : cas non prvu : distance point-droite sans longueur de rfrence");
				HS = true;
				return;
			    }
			    break;
			}
			break;
		    case GeoPlanJObjet.Vecteur:
			switch(antecedents[1].type) {
			case GeoPlanJObjet.Vecteur:
			    switch(antecedents[2].type) {
			    case GeoPlanJObjet.Nombre: //angle de deux vecteurs
				double dx = ((GeoPlanJVecteur)antecedents[0]).x * ((GeoPlanJVecteur)antecedents[1]).x
				    + ((GeoPlanJVecteur)antecedents[0]).y * ((GeoPlanJVecteur)antecedents[1]).y;
				double dy = ((GeoPlanJVecteur)antecedents[0]).y * ((GeoPlanJVecteur)antecedents[1]).x
				    - ((GeoPlanJVecteur)antecedents[0]).x * ((GeoPlanJVecteur)antecedents[1]).y;
				valeur = Math.atan2(dy, dx) / ((GeoPlanJNombre)antecedents[2]).valeur;
				HS = false;
				break;
			    default:
				System.out.println("Erreur : cas non prvu : distance deux vecteurs sans angle");
				HS = true;
				return;
			    }
			    break;
			default:
			    System.out.println("Erreur : cas non prvu : distance vecteur, ?, ?");
			    HS = true;
			    return;
			}
			break;
		    default:
			System.out.println("Erreur : cas non prvu : distance ?, ?, ?");
			HS = true;
			return;
		    }
		    break;
		case 4:
		    switch(antecedents[0].type) {
		    case GeoPlanJObjet.Point:
			switch(antecedents[1].type) {
			case GeoPlanJObjet.Point:
			    switch(antecedents[2].type) {
			    case GeoPlanJObjet.Point:
				switch(antecedents[3].type) {
				case GeoPlanJObjet.Nombre:
				    double x0 = ((GeoPlanJPoint)antecedents[0]).x - ((GeoPlanJPoint)antecedents[1]).x;
				    double y0 = ((GeoPlanJPoint)antecedents[0]).y - ((GeoPlanJPoint)antecedents[1]).y;
				    double x1 = ((GeoPlanJPoint)antecedents[2]).x - ((GeoPlanJPoint)antecedents[1]).x;
				    double y1 = ((GeoPlanJPoint)antecedents[2]).y - ((GeoPlanJPoint)antecedents[1]).y;
				    if(((GeoPlanJNombre)antecedents[3]).nom.equals("degr")) {
					double dx = x0 * x1 + y0 * y1;
					double dy = x1 * y0 - x0 * y1;
					if(Math.abs(dx) < 0.00001 && Math.abs(dy) < 0.00001) {
					    HS = true;
					} else {
					    valeur = Math.atan2(dy, dx) / ((GeoPlanJNombre)antecedents[3]).valeur;
					    HS = false;
					}
				    } else if(((GeoPlanJNombre)antecedents[3]).nom.equals("radian")) {
					double dx = x0 * x1 + y0 * y1;
					double dy = x1 * y0 - x0 * y1;
					if(Math.abs(dx) < 0.00001 && Math.abs(dy) < 0.00001) {
					    HS = true;
					} else {
					    valeur = Math.atan2(dy, dx);// ((GeoPlanJNombre)antecedents[3]).valeur;//radian.valeur = 1 car Java calcule en radian
					    HS = false;
					}
				    } else {
					valeur = Math.abs(x0*y1 - x1*y0) / (((GeoPlanJNombre)antecedents[3]).valeur * ((GeoPlanJNombre)antecedents[3]).valeur);
					HS = false;
				    }
				    break;
				default:
				    System.out.println("Erreur : cas non prvu : distance point, point, point, ?");
				    HS = true;
				    return;
				}
				break;
			    default:
				System.out.println("Erreur : cas non prvu : distance point, point, ?, ?");
				HS = true;
				return;
			    }
			    break;
			default:
			    System.out.println("Erreur : cas non prvu : distance point, ?, ?, ?");
			    HS = true;
			    return;
			}
			break;
		    default:
			System.out.println("Erreur : cas non prvu : distance ?, ?, ?, ?");
			HS = true;
			return;
		    }
		    break;
		default:
		    System.out.println("Erreur : distance de type non prvu");
		    HS = true;
		    return;
		}
		break;
		// pour les oprations qui suivent, on part du principe que 
		// les objets sont forcment deux, et qu'ils sont des nombres
		// s'il n'y a pas de BUG!!!
	    case Addition:
		valeur = ((GeoPlanJNombre)antecedents[0]).valeur + ((GeoPlanJNombre)antecedents[1]).valeur;
		HS = false;
		break;
	    case Soustraction:
		valeur = ((GeoPlanJNombre)antecedents[0]).valeur - ((GeoPlanJNombre)antecedents[1]).valeur;
		HS = false;
		break;
	    case Multiplication:
		if(antecedents[0].type == GeoPlanJObjet.Nombre && antecedents[1].type == GeoPlanJObjet.Nombre) {
		    valeur = ((GeoPlanJNombre)antecedents[0]).valeur * ((GeoPlanJNombre)antecedents[1]).valeur;
		    HS = false;
		} else if(antecedents[0].type == GeoPlanJObjet.Vecteur && antecedents[1].type == GeoPlanJObjet.Vecteur) {
		    valeur = (((GeoPlanJVecteur)antecedents[0]).x * ((GeoPlanJVecteur)antecedents[1]).x
			      + ((GeoPlanJVecteur)antecedents[0]).y * ((GeoPlanJVecteur)antecedents[1]).y)
			/ (figure.uniteParDefaut.valeur * figure.uniteParDefaut.valeur);
		    HS = false;
		} else {
		    HS = true;
		}
		break;
	    case Division:
		if(((GeoPlanJNombre)antecedents[1]).valeur != 0) {
		    valeur = ((GeoPlanJNombre)antecedents[0]).valeur / ((GeoPlanJNombre)antecedents[1]).valeur;
		    HS = false;
		} else {
		    HS = true;
		}
		break;
	    case Puissance:
		valeur = Math.pow(((GeoPlanJNombre)antecedents[0]).valeur,((GeoPlanJNombre)antecedents[1]).valeur);
		HS = false;
		break;
	    case Fonction:
		//System.out.println("fonction");
		/* le test des valeurs HS est fait dans la fonction
		   // il n'est plus faisable ici,  cause du passage aux fonctions de 
		   // plusieurs variables (GeoPlanJNombre ou GeoPlanJPoint)
		   if(antecedents[1].HS) {
		   HS = true;
		   break;
		   }
		   ((GeoPlanJFonction)antecedents[0]).initialise();
		   HS = false;
		   for(int i = 0; i < tableau.length; i++) {
		   if( ! ((GeoPlanJFonction)antecedents[0]).valeurDeLaVariable(tableau[i]) ) {
		   HS = true;
		   }
		   }
		   if(!HS) {
		   valeur = ((GeoPlanJFonction)antecedents[0]).valeur(largeur, hauteur, echelle);
		   //System.out.println("la fonction vaut : " + Double.toString(valeur));
		   if(valeur==Double.NaN) {
		   HS = true;
		   }
		   }
		*/
		// ce qui suit est provisoire en attendant de passer aux antcdents
		GeoPlanJObjet[] tableau = new GeoPlanJObjet[antecedents.length - 1];
		System.arraycopy(antecedents, 1, tableau, 0, tableau.length);
		valeur = ((GeoPlanJFonction)antecedents[0]).valeurPour(tableau);
		//System.out.println("la fonction " + ((GeoPlanJFonction)antecedents[0]).nom + " vaut " + Double.toString(valeur) + " lorsque la variable " + tableau[0].nom + " vaut " + Double.toString(((GeoPlanJNombre)tableau[0]).valeur));
		if(valeur==Double.NaN) {
		    HS = true;
		} else {
		    HS = false;
		}
		break;
	    case Transformation:// est-ce utile ? est-ce valable ?
		valeur = ((GeoPlanJNombre)antecedents[0]).valeur * Math.sqrt(Math.abs(((GeoPlanJTransform)antecedents[1]).ax * ((GeoPlanJTransform)antecedents[1]).by - ((GeoPlanJTransform)antecedents[1]).bx * ((GeoPlanJTransform)antecedents[1]).ay));
		break;
	    case Rayon:
		switch(antecedents.length) {
		case 1:
		    valeur = ((GeoPlanJCercle)antecedents[0]).R;
		    break;
		case 2:
		    valeur = ((GeoPlanJCercle)antecedents[0]).R * Math.sqrt(Math.abs(((GeoPlanJTransform)antecedents[1]).ax * ((GeoPlanJTransform)antecedents[1]).by - ((GeoPlanJTransform)antecedents[1]).bx * ((GeoPlanJTransform)antecedents[1]).ay));
		    break;
		default:
		    System.out.println("Erreur : cas non prvu, dans Rayon");
		}
		break;
	    case Minimum:
		HS = false;
		if(((GeoPlanJNombre)antecedents[0]).valeur < ((GeoPlanJNombre)antecedents[1]).valeur) {
		    valeur = ((GeoPlanJNombre)antecedents[0]).valeur;
		} else {
		    valeur = ((GeoPlanJNombre)antecedents[1]).valeur;
		}
		break;
	    case Maximum:
		HS = false;
		if(((GeoPlanJNombre)antecedents[0]).valeur < ((GeoPlanJNombre)antecedents[1]).valeur) {
		    valeur = ((GeoPlanJNombre)antecedents[1]).valeur;
		} else {
		    valeur = ((GeoPlanJNombre)antecedents[0]).valeur;
		}
		break;
	    case Abscisse:
		valeur = ( ( ((GeoPlanJPoint)antecedents[0]).x - ((GeoPlanJRepere)antecedents[1]).cx ) * ((GeoPlanJRepere)antecedents[1]).by - ( ((GeoPlanJPoint)antecedents[0]).y - ((GeoPlanJRepere)antecedents[1]).cy ) * ((GeoPlanJRepere)antecedents[1]).bx) / ( ((GeoPlanJRepere)antecedents[1]).ax * ((GeoPlanJRepere)antecedents[1]).by - ((GeoPlanJRepere)antecedents[1]).ay * ((GeoPlanJRepere)antecedents[1]).bx );
		//System.out.println("abscisse = " + Double.toString(valeur));
		HS = false;
		break;
	    case Ordonnee:
		valeur = ( ( ((GeoPlanJPoint)antecedents[0]).y - ((GeoPlanJRepere)antecedents[1]).cy ) * ((GeoPlanJRepere)antecedents[1]).ax -  ( ((GeoPlanJPoint)antecedents[0]).x - ((GeoPlanJRepere)antecedents[1]).cx ) * ((GeoPlanJRepere)antecedents[1]).ay ) / ( ((GeoPlanJRepere)antecedents[1]).ax * ((GeoPlanJRepere)antecedents[1]).by - ((GeoPlanJRepere)antecedents[1]).ay * ((GeoPlanJRepere)antecedents[1]).bx );
		//System.out.println("ordonne = " + Double.toString(valeur));
		HS = false;
		break;
	    case Et:
		HS = false;
		if(((GeoPlanJNombre)antecedents[0]).valeur == 0 || ((GeoPlanJNombre)antecedents[1]).valeur == 0) {
		    valeur = 0;
		} else {
		    valeur = 1;
		}
		break;
	    case Ou:
		HS = false;
		if(((GeoPlanJNombre)antecedents[0]).valeur == 0 && ((GeoPlanJNombre)antecedents[1]).valeur == 0) {
		    valeur = 0;
		} else {
		    valeur = 1;
		}
		break;
	    case OuEx:
		HS = false;
		if((((GeoPlanJNombre)antecedents[0]).valeur == 0 && ((GeoPlanJNombre)antecedents[1]).valeur != 0) || (((GeoPlanJNombre)antecedents[0]).valeur != 0 && ((GeoPlanJNombre)antecedents[1]).valeur == 0)) {
		    valeur = 1;
		} else {
		    valeur = 0;
		}
		break;
	    case Non:
		HS = false;
		if(((GeoPlanJNombre)antecedents[0]).valeur == 0) {
		    valeur = 1;
		} else {
		    valeur = 0;
		}
		break;
	    case Egal:
		HS = false;
		if(((GeoPlanJNombre)antecedents[0]).valeur == ((GeoPlanJNombre)antecedents[1]).valeur) {
		    valeur = 1;
		} else {
		    valeur = 0;
		}
		break;
	    case Different:
		HS = false;
		if(((GeoPlanJNombre)antecedents[0]).valeur != ((GeoPlanJNombre)antecedents[1]).valeur) {
		    valeur = 1;
		} else {
		    valeur = 0;
		}
		break;
	    case Inferieur:
		//System.out.println("Inferieur : " + this.nom);
		//System.out.println(((GeoPlanJNombre)antecedents[0]).nom);
		//System.out.println(((GeoPlanJNombre)antecedents[0]).valeur);
		//System.out.println(((GeoPlanJNombre)antecedents[1]).nom);
		//System.out.println(((GeoPlanJNombre)antecedents[1]).valeur);
		HS = false;
		if(((GeoPlanJNombre)antecedents[0]).valeur < ((GeoPlanJNombre)antecedents[1]).valeur) {
		    valeur = 1;
		} else {
		    valeur = 0;
		}
		break;
	    case InferieurOuEgal:
		HS = false;
		if(((GeoPlanJNombre)antecedents[0]).valeur <= ((GeoPlanJNombre)antecedents[1]).valeur) {
		    valeur = 1;
		} else {
		    valeur = 0;
		}
		break;
	    case Superieur:
		HS = false;
		if(((GeoPlanJNombre)antecedents[0]).valeur > ((GeoPlanJNombre)antecedents[1]).valeur) {
		    valeur = 1;
		} else {
		    valeur = 0;
		}
		break;
	    case SuperieurOuEgal:
		HS = false;
		if(((GeoPlanJNombre)antecedents[0]).valeur >= ((GeoPlanJNombre)antecedents[1]).valeur) {
		    valeur = 1;
		} else {
		    valeur = 0;
		}
		break;
	    default:
		System.out.println("Erreur : param(GeoPlanJNombre) non prvu");
		HS = true;
		return;
	    }
	    break;
	}
	if(Math.abs(valeur) < 0.00001) {
	    valeur = 0;
	}
    }
    int copie(GeoPlanJObjet obj) {
	if(obj.type == GeoPlanJObjet.Nombre) {
	    this.valeur = ((GeoPlanJNombre)obj).valeur;
	    return(0);
	} else {
	    System.out.println("Erreur : tentative de copier un objet de mauvais type");
	    return(-1);
	}
    }
}
