import java.awt.Graphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;

class GeoPlanJPoint extends GeoPlanJObjetDessinable {
    //attention, dans ce qui suit, les nombres positifs sont prohibs, car ils servent pour le nombre de liberts du point
    public static final int Normal = 0;
    public static final int CentreDeGravite = -1;
    public static final int CentreDuCercleCirconscrit = -2;
    public static final int CentreDuCercleInscrit = -3;
    public static final int Orthocentre = -4;
    //public static final int  = -5;
    double x, y;
    //GeoPlanJObjet objet1;
    //GeoPlanJObjet objet2;
    //boolean libre;
    int positionDuNom;// 0 : nom non dessine, 1 : nom "libre"
    // 2 : nom  gauche, 3 : nom au dessus et  gauche ... etc ...
    boolean coordonneesEntieres;
    GeoPlanJPoint(String nom, GeoPlanJObjet[] antecedents, int sousType, int param, GeoPlanJFigure figure, int numeroEcran) {
	this.nom = nom;
	this.type = GeoPlanJObjet.Point;
	this.antecedents = antecedents;
	this.sousType = sousType;
	this.param = param;
	this.figure = figure;
	this.numeroEcran = numeroEcran;
	this.couleur = Color.black;
	this.coordonneesEntieres = false;//par dfaut  la cration
	//System.out.println("point dfini par le prototype n" + Integer.toString(param));
	//System.out.println("le nombre d'antecedents est " + Integer.toString(antecedents.length));
	//System.out.print("   dont les antcdents sont : " + antecedents[0].nom);
	//for(int i = 1 ; i < antecedents.length ; i++) {
	//System.out.print(", " + antecedents[i].nom);
	//}
	//System.out.println("|");
    }
    // particularitesParDefaut sert lorsqu'on utilise la phrase Objet dessinable ... particularits ...
    void particularitesParDefaut() {
	couleur = Color.black;
	epaisseur = 2;
	positionDuNom = 1;
    }
    void particularite(String texte) {
	Color tempColor = figure.couleurNommee(texte);
	if(tempColor != null) {
	    couleur = tempColor;
	    return;
	    /*
	if("couleur du fond".equals(texte)) {
	    couleur = Color.white;//y a-t-il d'autre couleur de fond possible
	} else if("gris".equals(texte)) {
	    couleur = Color.lightGray;
	} else if("gris fonc".equals(texte)) {
	    couleur = Color.lightGray.darker();
	} else if("rose".equals(texte)) {
	    couleur = Color.pink;
	} else if("rose fonc".equals(texte)) {
	    couleur = Color.pink.darker();
	} else if("rouge".equals(texte)) {
	    couleur = Color.red;
	} else if("rouge fonc".equals(texte)) {
	    couleur = Color.red.darker();
	} else if("ciel".equals(texte)) {
	    couleur = Color.cyan;
	} else if("ciel fonc".equals(texte)) {
	    couleur = Color.cyan.darker();
	} else if("bleu".equals(texte)) {
	    couleur = Color.blue;
	} else if("bleu fonc".equals(texte)) {
	    couleur = Color.blue.darker();
	} else if("jaune".equals(texte)) {
	    couleur = Color.yellow;
	} else if("jaune fonc".equals(texte)) {
	    couleur = Color.yellow.darker();
	} else if("vert".equals(texte)) {
	    couleur = Color.green;
	} else if("vert fonc".equals(texte)) {
	    couleur = Color.green.darker();
	    */
	} else if("dessin".equals(texte)) {
	    epaisseur = 2;
	    positionDuNom = 1;
	} else if("non dessin".equals(texte)) {
	    epaisseur = 0;
	    positionDuNom = 0;
	} else if("marque fine".equals(texte)) {
	    epaisseur = 1;
	} else if("marque paisse".equals(texte)) {
	    epaisseur = 3;
	} else if("marque non dessine".equals(texte)) {
	    positionDuNom = 0;
	} else if("nom non dessin".equals(texte)) {
	    positionDuNom = 0;
	} else if("nom  gauche".equals(texte)) {
	    switch(positionDuNom) {
	    case 4:
	    case 5:
		positionDuNom = 3;
		break;
	    case 0:
	    case 1:
	    case 6:
		positionDuNom = 2;
		break;
	    case 7:
	    case 8:
		positionDuNom = 9;
		break;
	    }
	} else if("nom  droite".equals(texte)) {
	    switch(positionDuNom) {
	    case 3:
	    case 4:
		positionDuNom = 5;
		break;
	    case 0:
	    case 1:
	    case 2:
		positionDuNom = 6;
		break;
	    case 8:
	    case 9:
		positionDuNom = 7;
		break;
	    }
	} else if("nom au-dessus".equals(texte)) {
	    switch(positionDuNom) {
	    case 2:
	    case 9:
		positionDuNom = 3;
		break;
	    case 0:
	    case 1:
	    case 8:
		positionDuNom = 4;
		break;
	    case 6:
	    case 7:
		positionDuNom = 5;
		break;
	    }
	} else if("nom au-dessous".equals(texte)) {
	    switch(positionDuNom) {
	    case 2:
	    case 3:
		positionDuNom = 9;
		break;
	    case 0:
	    case 1:
	    case 4:
		positionDuNom = 8;
		break;
	    case 5:
	    case 6:
		positionDuNom = 7;
		break;
	    }
	} else {
	    System.out.println("particularite " + texte + " est inconnue, donc ignoree");
	}
	// marque fine : 1x1 pixel
	// (normal) : 2x2 pixels
	// marque paisse : 3x3 pixels
    }
    void dessine() {
	if(!HS) {
	    //if(figure.offgraph == null) {
	    //System.out.println("c'est nul");
	    //}
	    dessinePoint(figure.offgraph[numeroEcran * figure.traceActive], x, y, epaisseur, couleur);
	    dessineNomDuPoint(figure.offgraph[0], x, y, positionDuNom, couleur, nom, figure.metriqueDeFontes);
	}
    }
    void miseAJour() {
	/*
	System.out.println("ce point se nomme " + this.nom);
	System.out.println("il a " + antecedents.length + " antcdents");
	for(int i = 0 ; i < antecedents.length ; i++) {
	    System.out.println("antecedent " + (i + 1) + " : " + antecedents[i].nom);
	}
	*/
	for(int i = 0 ; i < antecedents.length ; i++) {
	    if(antecedents[i].HS) {
		this.HS = true;
		return;
	    }
	}
	switch(sousType) {
	default:
	    //cas des Prototypes
	    GeoPlanJObjet proto = miseAJourPrototype();
	    //System.out.println("miseAJourPrototype renvoie l'objet " + proto.nom);
	    //System.out.println(" de params : " + ((GeoPlanJPoint)proto).x + ", " + ((GeoPlanJPoint)proto).y);
	    if(proto == null) {
		HS = true;
		return;
	    }
	    this.x = ((GeoPlanJPoint)proto).x;
	    this.y = ((GeoPlanJPoint)proto).y;
	    //System.out.println("prototype mis  jour");
	    HS = false;
	    break;
	case Normal:
	    switch(antecedents.length) {
	    case 1: // centre d'un cercle
		//System.out.println("1 antcdent : " + this.nom);
		switch(antecedents[0].type) {
		case GeoPlanJObjet.Cercle:
		    x = ((GeoPlanJCercle)antecedents[0]).x;
		    y = ((GeoPlanJCercle)antecedents[0]).y;
		    HS = false;
		    break;
		default:
		    System.out.println("ERREUR!!! cas non prvue");
		    HS = true;
		    return;
		}
		break;
	    case 2:
		//System.out.println("2 antcdents : " + this.nom);
		switch(antecedents[0].type) {
		case GeoPlanJObjet.Nombre://donc deux coordonnes uniquement (cas exclusif de o)
		    switch(antecedents[1].type) {
		    case GeoPlanJObjet.Nombre:
			x = ((GeoPlanJNombre)antecedents[0]).valeur;
			y = ((GeoPlanJNombre)antecedents[1]).valeur;
			//System.out.println("x de o = " + Double.toString(((GeoPlanJNombre)antecedents[0]).valeur));
			//System.out.println("y de o = " + Double.toString(((GeoPlanJNombre)antecedents[1]).valeur));
			HS = false;
			break;
		    default:
			System.out.println("un point non prototype ne peut tre dfini par un nombre et autre chose qu'un nombre");
			HS = true;
			return;
		    }
		    break;
		case GeoPlanJObjet.Point:
		    //System.out.println("le premier objet est un point");
		    switch(antecedents[1].type) {
		    case GeoPlanJObjet.Repere:
			//System.out.println("on est la");
			x = ((GeoPlanJRepere)antecedents[1]).ax * ((GeoPlanJPoint)antecedents[0]).x +
			    ((GeoPlanJRepere)antecedents[1]).bx * ((GeoPlanJPoint)antecedents[0]).y +
			    ((GeoPlanJRepere)antecedents[1]).cx;
			y = ((GeoPlanJRepere)antecedents[1]).ay * ((GeoPlanJPoint)antecedents[0]).x +
			    ((GeoPlanJRepere)antecedents[1]).by * ((GeoPlanJPoint)antecedents[0]).y +
			    ((GeoPlanJRepere)antecedents[1]).cy;
			HS = false;
			break;
		    case GeoPlanJObjet.Transform:
			x = ((GeoPlanJTransform)antecedents[1]).ax * ((GeoPlanJPoint)antecedents[0]).x +
			    ((GeoPlanJTransform)antecedents[1]).bx * ((GeoPlanJPoint)antecedents[0]).y +
			    ((GeoPlanJTransform)antecedents[1]).cx;
			y = ((GeoPlanJTransform)antecedents[1]).ay * ((GeoPlanJPoint)antecedents[0]).x +
			    ((GeoPlanJTransform)antecedents[1]).by * ((GeoPlanJPoint)antecedents[0]).y +
			    ((GeoPlanJTransform)antecedents[1]).cy;
			HS = false;
			break;
		    case GeoPlanJObjet.Point://milieu de deux points
			//System.out.println("Milieu");
			x = (((GeoPlanJPoint)antecedents[0]).x + ((GeoPlanJPoint)antecedents[1]).x) / 2;
			y = (((GeoPlanJPoint)antecedents[0]).y + ((GeoPlanJPoint)antecedents[1]).y) / 2;
			HS = false;
			break;
		    case GeoPlanJObjet.Vecteur:// translat
			x = ((GeoPlanJPoint)antecedents[0]).x + ((GeoPlanJVecteur)antecedents[1]).x;
			y = ((GeoPlanJPoint)antecedents[0]).y + ((GeoPlanJVecteur)antecedents[1]).y;
			HS = false;
			break;
		    default:
			System.out.println("cas non prvu pour " + nom);
			HS = true;
			return;
		    }
		    break;
		case GeoPlanJObjet.Droite://
		    switch(antecedents[1].type) {
		    case GeoPlanJObjet.Nombre://point sur droite
			//System.out.println("point sur droite");
			double lambda = ((GeoPlanJNombre)antecedents[1]).valeur;
			if(coordonneesEntieres) {
			    lambda = Math.round(lambda);
			}
			x = ((GeoPlanJDroite)antecedents[0]).x0 + lambda * (((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0);
			y = ((GeoPlanJDroite)antecedents[0]).y0 + lambda * (((GeoPlanJDroite)antecedents[0]).y1 - ((GeoPlanJDroite)antecedents[0]).y0);
			HS = false;
			break;
		    case GeoPlanJObjet.Droite://intersection de deux droites
			double a1 = ((GeoPlanJDroite)antecedents[0]).y0 - ((GeoPlanJDroite)antecedents[0]).y1;
			double b1 = ((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0;
			double c1 = ((GeoPlanJDroite)antecedents[0]).x0 * ((GeoPlanJDroite)antecedents[0]).y1 - ((GeoPlanJDroite)antecedents[0]).x1 * ((GeoPlanJDroite)antecedents[0]).y0;
			double a2 = ((GeoPlanJDroite)antecedents[1]).y0 - ((GeoPlanJDroite)antecedents[1]).y1;
			double b2 = ((GeoPlanJDroite)antecedents[1]).x1 - ((GeoPlanJDroite)antecedents[1]).x0;
			double c2 = ((GeoPlanJDroite)antecedents[1]).x0 * ((GeoPlanJDroite)antecedents[1]).y1 - ((GeoPlanJDroite)antecedents[1]).x1 * ((GeoPlanJDroite)antecedents[1]).y0;
			double determinant = a1 * b2 - a2 * b1;
			if(determinant == 0) { // ne devrait-on pas tester "trs petit" plutot que "nul"
			    HS = true;
			    return;
			} else {
			    x = (b1 * c2 - b2 * c1)/determinant;
			    y = (c1 * a2 - c2 * a1)/determinant;
			    HS = false;
			}
			break;
		    case GeoPlanJObjet.Cercle://Droite et cercle
			a1 = ((GeoPlanJDroite)antecedents[0]).y0 - ((GeoPlanJDroite)antecedents[0]).y1;
			b1 = ((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0;
			c1 = ((GeoPlanJDroite)antecedents[0]).x0 * ((GeoPlanJDroite)antecedents[0]).y1
			    -((GeoPlanJDroite)antecedents[0]).x1 * ((GeoPlanJDroite)antecedents[0]).y0;
			double denominateur = a1 * a1 + b1 * b1;
			double alpha =
			    (a1 * ((GeoPlanJCercle)antecedents[1]).x +
			     b1 * ((GeoPlanJCercle)antecedents[1]).y +
			     c1) / denominateur;
			double gamma = Math.pow(((GeoPlanJCercle)antecedents[1]).R, 2) / denominateur;
			if((alpha *alpha) > gamma) {
			    HS = true;
			    return;
			} else {
			    HS = false;
			    double beta = Math.sqrt(gamma - (alpha * alpha));
			    x = ((GeoPlanJCercle)antecedents[1]).x - alpha * a1 + beta * b1;
			    y = ((GeoPlanJCercle)antecedents[1]).y - alpha * b1 - beta * a1;
			}
			break;
		    }
		    break;
		case GeoPlanJObjet.Cercle:
		    switch(antecedents[1].type) {
		    case GeoPlanJObjet.Nombre://point sur cercle
			x = ((GeoPlanJCercle)antecedents[0]).x + ((GeoPlanJCercle)antecedents[0]).R * Math.cos(((GeoPlanJNombre)antecedents[1]).valeur);
			y = ((GeoPlanJCercle)antecedents[0]).y - ((GeoPlanJCercle)antecedents[0]).R * Math.sin(((GeoPlanJNombre)antecedents[1]).valeur);
			HS = false;
			break;
		    case GeoPlanJObjet.Droite://Cercle et droite
			double a2 = ((GeoPlanJDroite)antecedents[1]).y0 - ((GeoPlanJDroite)antecedents[1]).y1;
			double b2 = ((GeoPlanJDroite)antecedents[1]).x1 - ((GeoPlanJDroite)antecedents[1]).x0;
			double c2 = ((GeoPlanJDroite)antecedents[1]).x0 * ((GeoPlanJDroite)antecedents[1]).y1
			    - ((GeoPlanJDroite)antecedents[1]).x1 * ((GeoPlanJDroite)antecedents[1]).y0;
			double denominateur = a2 * a2 + b2 * b2;
			double alpha =
			    (a2 * ((GeoPlanJCercle)antecedents[0]).x +
			     b2 * ((GeoPlanJCercle)antecedents[0]).y +
			     c2) / denominateur;
			double gamma = Math.pow(((GeoPlanJCercle)antecedents[0]).R, 2) / denominateur;
			if((alpha *alpha) > gamma) {
			    HS = true;
			} else {
			    HS = false;
			    double beta = Math.sqrt(gamma - (alpha * alpha));
			    x = ((GeoPlanJCercle)antecedents[0]).x - alpha * a2 - beta * b2;
			    y = ((GeoPlanJCercle)antecedents[0]).y - alpha * b2 + beta * a2;
			}
			break;
		    case GeoPlanJObjet.Cercle://Cercle et cercle
			double petitA =
			    2*(((GeoPlanJCercle)antecedents[1]).x - ((GeoPlanJCercle)antecedents[0]).x);
			double petitB =
			    2*(((GeoPlanJCercle)antecedents[1]).y - ((GeoPlanJCercle)antecedents[0]).y);
			double petitC =
			    Math.pow(((GeoPlanJCercle)antecedents[0]).x, 2)
			    - Math.pow(((GeoPlanJCercle)antecedents[1]).x, 2)
			    + Math.pow(((GeoPlanJCercle)antecedents[0]).y, 2)
			    - Math.pow(((GeoPlanJCercle)antecedents[1]).y, 2)
			    - Math.pow(((GeoPlanJCercle)antecedents[0]).R, 2)
			    + Math.pow(((GeoPlanJCercle)antecedents[1]).R, 2);
			denominateur =
			    Math.pow(petitA, 2) +
			    Math.pow(petitB, 2);
			alpha =
			    (petitA * ((GeoPlanJCercle)antecedents[0]).x
			     + petitB * ((GeoPlanJCercle)antecedents[0]).y
			     + petitC) / denominateur;
			gamma = Math.pow(((GeoPlanJCercle)antecedents[0]).R, 2) / denominateur;
			if(Math.pow(alpha, 2) > gamma) {
			    HS = true;
			} else {
			    HS = false;
			    double beta = Math.sqrt(gamma - Math.pow(alpha, 2));
			    x = ((GeoPlanJCercle)antecedents[0]).x - 
				alpha * petitA + beta * petitB;
			    y = ((GeoPlanJCercle)antecedents[0]).y - 
				alpha * petitB - beta * petitA;
			}
			break;
		    }
		    break;
		default:
		    System.out.println("ERREUR!!! cas non prvue");
		    HS = true;
		    return;
		}
		break;
	    case 3:
		//System.out.println("3 antcdents : " + this.nom);
		switch(param) {
		case 2:// 2 liberts
		case 0:
		    switch(antecedents[0].type) {
		    case GeoPlanJObjet.Nombre://donc deux coordonnes, dans un repre, sinon erreur
			switch(antecedents[1].type) {
			case GeoPlanJObjet.Nombre:
			    switch(antecedents[2].type) {
			    case GeoPlanJObjet.Repere:
				double X = ((GeoPlanJNombre)antecedents[0]).valeur;
				double Y = ((GeoPlanJNombre)antecedents[1]).valeur;
				if(coordonneesEntieres) {
				    X = Math.round(X);
				    Y = Math.round(Y);
				}
				x = ((GeoPlanJRepere)antecedents[2]).ax * X + ((GeoPlanJRepere)antecedents[2]).bx * Y + ((GeoPlanJRepere)antecedents[2]).cx;
				y = ((GeoPlanJRepere)antecedents[2]).ay * X + ((GeoPlanJRepere)antecedents[2]).by * Y + ((GeoPlanJRepere)antecedents[2]).cy;
				HS = false;
				break;
			    default:
				System.out.println("erreur : un point ne peut pas tre dfini par deux nombres dans autre chose qu'un repre");
				HS = true;
				return;
			    }
			    break;
			default:
			    System.out.println("Erreur : type du deuxime antcdent de " + this.nom + " non prvu");
			    HS = true;
			    return;
			}
			break;
		    default:
			System.out.println("Erreur : type du premier antcdent de " + this.nom + " non prvu");
			HS = true;
			return;
		    }
		    break;
		case -1:// centre de gravit
		    x = (((GeoPlanJPoint)antecedents[0]).x + ((GeoPlanJPoint)antecedents[1]).x + ((GeoPlanJPoint)antecedents[2]).x) / 3;
		    y = (((GeoPlanJPoint)antecedents[0]).y + ((GeoPlanJPoint)antecedents[1]).y + ((GeoPlanJPoint)antecedents[2]).y) / 3;
		    HS = false;
		    break;
		case -2:// centre du cercle circonscrit
		    double dx1 = ((GeoPlanJPoint)antecedents[0]).x - ((GeoPlanJPoint)antecedents[1]).x;
		    double sx1 = ((GeoPlanJPoint)antecedents[0]).x + ((GeoPlanJPoint)antecedents[1]).x;
		    double dx2 = ((GeoPlanJPoint)antecedents[0]).x - ((GeoPlanJPoint)antecedents[2]).x;
		    double sx2 = ((GeoPlanJPoint)antecedents[0]).x + ((GeoPlanJPoint)antecedents[2]).x;
		    double dy1 = ((GeoPlanJPoint)antecedents[0]).y - ((GeoPlanJPoint)antecedents[1]).y;
		    double sy1 = ((GeoPlanJPoint)antecedents[0]).y + ((GeoPlanJPoint)antecedents[1]).y;
		    double dy2 = ((GeoPlanJPoint)antecedents[0]).y - ((GeoPlanJPoint)antecedents[2]).y;
		    double sy2 = ((GeoPlanJPoint)antecedents[0]).y + ((GeoPlanJPoint)antecedents[2]).y;
		    double prod0 = dx1 * dx2;
		    double prod1 = dy1 * dy2;
		    double prod2 = dx1 * dy2;
		    double prod3 = dx2 * dy1;
		    double det = 2 * (dx1 * dy2 - dx2 * dy1);
		    if(Math.abs(det) < 0.0001) {
			HS = true;
			return;
		    } else {
			x = (prod2 * sx1 + prod1 * sy1 - prod3 * sx2 - prod1 * sy2) / det;
			y = (prod0 * sx2 + prod2 * sy2 - prod0 * sx1 - prod3 * sy1) / det;
			HS = false;
		    }
		    break;
		case -3:// centre du cercle inscrit
		    dx1 = ((GeoPlanJPoint)antecedents[0]).x - ((GeoPlanJPoint)antecedents[1]).x;
		    dx2 = ((GeoPlanJPoint)antecedents[1]).x - ((GeoPlanJPoint)antecedents[2]).x;
		    double dx3 = ((GeoPlanJPoint)antecedents[2]).x - ((GeoPlanJPoint)antecedents[0]).x;
		    dy1 = ((GeoPlanJPoint)antecedents[0]).y - ((GeoPlanJPoint)antecedents[1]).y;
		    dy2 = ((GeoPlanJPoint)antecedents[1]).y - ((GeoPlanJPoint)antecedents[2]).y;
		    double dy3 = ((GeoPlanJPoint)antecedents[2]).y - ((GeoPlanJPoint)antecedents[0]).y;
		    double AB = Math.sqrt(dx1 * dx1 + dy1 * dy1);
		    double BC = Math.sqrt(dx2 * dx2 + dy2 * dy2);
		    double CA = Math.sqrt(dx3 * dx3 + dy3 * dy3);
		    double cx1 = dx1 / AB;
		    double cx2 = dx2 / BC;
		    double cx3 = dx3 / CA;
		    double cy1 = dy1 / AB;
		    double cy2 = dy2 / BC;
		    double cy3 = dy3 / CA;
		    double alpha1 = cx3 + cx1;
		    double beta1 = cy3 + cy1;
		    double gamma1 = alpha1 * ((GeoPlanJPoint)antecedents[0]).x + beta1 * ((GeoPlanJPoint)antecedents[0]).y;
		    double alpha2 = cx1 + cx2;
		    double beta2 = cy1 + cy2;
		    double gamma2 = alpha2 * ((GeoPlanJPoint)antecedents[1]).x + beta2 * ((GeoPlanJPoint)antecedents[1]).y;
		    det = alpha1 * beta2 - alpha2 * beta1;
		    if(Math.abs(det) < 0.0001) {
			HS = true;
			return;
		    } else {
			x = (gamma1 * beta2 - gamma2 * beta1) / det;
			y = (alpha1 * gamma2 - alpha2 * gamma1) / det;
			HS = false;
		    }
		    break;
		case -4:// orthocentre
		    dx1 = ((GeoPlanJPoint)antecedents[0]).x - ((GeoPlanJPoint)antecedents[1]).x;
		    dx2 = ((GeoPlanJPoint)antecedents[0]).x - ((GeoPlanJPoint)antecedents[2]).x;
		    dx3 = ((GeoPlanJPoint)antecedents[1]).x - ((GeoPlanJPoint)antecedents[2]).x;
		    dy1 = ((GeoPlanJPoint)antecedents[0]).y - ((GeoPlanJPoint)antecedents[1]).y;
		    dy2 = ((GeoPlanJPoint)antecedents[0]).y - ((GeoPlanJPoint)antecedents[2]).y;
		    dy3 = ((GeoPlanJPoint)antecedents[1]).y - ((GeoPlanJPoint)antecedents[2]).y;
		    prod1 = dx1 * dy2;
		    prod2 = dx2 * dy1;
		    det = prod1 - prod2;
		    x = (((GeoPlanJPoint)antecedents[2]).x * prod1 - ((GeoPlanJPoint)antecedents[1]).x * prod2 - dy1 * dy2 * dy3) / det;
		    y = (dx1 * dx2 * dx3 + ((GeoPlanJPoint)antecedents[1]).y * prod1 - ((GeoPlanJPoint)antecedents[2]).y * prod2) / det;
		    HS = false;
		    break;
		default:
		    System.out.println("Erreur : type de " + this.nom + " non prvu");
		    HS = true;
		    return;
		}
		break;
	    default:
		System.out.println("Erreur : nombre d'antcdents de " + this.nom + " non prvu");
		HS = true;
		return;
	    }
	    break;
	case Libre:
	case Donne:
	case Variable: //impossible : seuls les nombres ont, pour le moment, ce type
	    return;
	}
    }
    void nouvellesCoords(int newX, int newY) {
	if(this.sousType == GeoPlanJPoint.Normal) {
	    switch(antecedents[0].type) {
		//doit-on prendre des prcautions ?
	    case GeoPlanJObjet.Nombre://cas totalement libre (dans roxy)
		// x' = ax*x + bx*y + cx
		// y' = ay*x + by*y + cy
		// x'-cx = ax*x + bx*y
		// y'-cy = ay*x + by*y
		// x = (by*(x'-cx) - bx*(y'-cy)) / (ax*by - ay*bx)
		// y = (ax*(y'-cy) - ay*(x'-cx)) / (ax*by - ay*bx)
		double det = ((GeoPlanJRepere)antecedents[2]).ax * ((GeoPlanJRepere)antecedents[2]).by - ((GeoPlanJRepere)antecedents[2]).ay * ((GeoPlanJRepere)antecedents[2]).bx;
		double xprime = newX - ((GeoPlanJRepere)antecedents[2]).cx;
		double yprime = newY - ((GeoPlanJRepere)antecedents[2]).cy;
		((GeoPlanJNombre)antecedents[0]).valeur = ( xprime * ((GeoPlanJRepere)antecedents[2]).by - yprime * ((GeoPlanJRepere)antecedents[2]).bx) / det;
		((GeoPlanJNombre)antecedents[1]).valeur = ( ((GeoPlanJRepere)antecedents[2]).ax * yprime - ((GeoPlanJRepere)antecedents[2]).ay * xprime) / det;
		break;
		/*
	    case GeoPlanJObjet.Point:// peut-il se produire ?
		break;
		*/
	    case GeoPlanJObjet.Cercle://point libre sur cercle
		// RAPPEL : la valeur correspond  l'angle en radian, par rapport  l'axe ox
		// on prendra comme nouvelle valeur, la plus proche, c'est--dire, dont la diffrence avec l'ancienne valeur est dans l'intervalle ]-PI;PI]
		double angle = Math.atan2(((GeoPlanJCercle)antecedents[0]).y - newY, newX - ((GeoPlanJCercle)antecedents[0]).x);// on met "((GeoPlanJCercle)antecedents[0]).y - newY" au lieu de "newY - ((GeoPlanJCercle)antecedents[0]).y"  cause de l'inversion des y sur l'cran (croissance des y vers le bas...)
		double vieilAngle = ((GeoPlanJNombre)antecedents[1]).valeur;
		((GeoPlanJNombre)antecedents[1]).valeur = angle + Math.floor((vieilAngle - angle + Math.PI) / (2*Math.PI)) * 2*Math.PI;
		//System.out.println("vieil angle = " + Double.toString(vieilAngle));
		//System.out.println("nouvel angle brut = " + Double.toString(angle));
		//System.out.println("(vieil angle - nouvel angle) / 2PI = " + Double.toString((angle - vieilAngle + Math.PI) / (2*Math.PI)));
		//System.out.println("(int)(vieil angle - nouvel angle) / 2PI = " + Double.toString((int)((angle - vieilAngle + Math.PI) / (2*Math.PI))));
		//System.out.println("Math.int((vieil angle - nouvel angle) / 2PI) = " + Double.toString(Math.floor((angle - vieilAngle + Math.PI) / (2*Math.PI))));
		//System.out.println("nouvel angle = " + Double.toString(((GeoPlanJNombre)antecedents[1]).valeur));
		// problme : quel est le nom de la fonction partie entire dans java.Math ?
		// rponse : c'est "double Math.floor(double)"
		// Remarque : attention! cette partie entire renvoie un double...
		/*
		  si vieilAngle = 5PI/2 et angle = PI/4
		  il faut trouver PI/4 + 2PI = 9PI/4
		  angle - vieilAngle + PI = -5PI/4
		  ... / 2PI = -5/8
		  la partie entire est -1

		  si vieilAngle = 5PI/2 et angle = -PI/4
		  il faut trouver -PI/4 + 2PI = 7PI/4
		  angle - vieilAngle + PI = -7PI/4
		  ... / 2PI = -7/8
		  la partie entire est -1

		  si vieilAngle = 15PI/2 et angle = 3PI/4
		  il faut trouver 3PI/4 + 3*2PI = 27PI/4
		  angle - vieilAngle + PI = -23PI/4
		  ... / 2PI = -23/8
		  la partie entire est -3
		*/
		break;
	    case GeoPlanJObjet.Droite://point libre sur droite
		double vec1x = newX - ((GeoPlanJDroite)antecedents[0]).x0;
		double vec1y = newY - ((GeoPlanJDroite)antecedents[0]).y0;
		double vec2x = ((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0;
		double vec2y = ((GeoPlanJDroite)antecedents[0]).y1 - ((GeoPlanJDroite)antecedents[0]).y0;
		((GeoPlanJNombre)antecedents[1]).valeur = (vec1x * vec2x + vec1y * vec2y) / (vec2x * vec2x + vec2y * vec2y);
		break;
	    }
	} // les points libres dfinis par prototype sont-ils possibles ?
    }
    public static void dessinePoint(Graphics g, double x, double y, int epaisseur, Color couleur) {
	if(x == Double.NaN || y == Double.NaN) {
	    return; // si l'une des coordonnes n'est pas un nombre, on ne fait rien
	}
	g.setColor(couleur);
	switch(epaisseur) {
	case 1:
	    g.fillRect((int)(x+0.5), (int)(y+0.5), 1, 1);
	    break;
	case 2:
	    g.fillRect((int)(x+0.5), (int)(y+0.5), 2, 2);
	    break;
	case 3:
	    g.fillRect((int)(x+0.5)-1, (int)(y+0.5)-1, 3, 3);
	    break;
	case 4:// point en croix
	    g.drawLine((int)(x+0.5) - 4, (int)(y+0.5), (int)(x+0.5) + 4, (int)(y+0.5));
	    g.drawLine((int)(x+0.5), (int)(y+0.5) - 4, (int)(x+0.5), (int)(y+0.5) + 4);
	    break;
	}
    }
    public static void dessineNomDuPoint(Graphics g, double x, double y, int positionDuNom, Color couleur, String nom, FontMetrics fm) {
	// il faudra grer l'criture en gras
	g.setColor(couleur);
	switch(positionDuNom) {
	case 1:// cas libre
	    g.drawString(nom, (int)(x+0.5) + 4, (int)(y+0.5) - 4);
	    break;
	case 2:// W
	    g.drawString(nom, (int)(x+0.5) - 5 - fm.stringWidth(nom), (int)(y+0.5) + ((int)fm.getAscent() / 2));
	    break;
	case 3:// NW
	    g.drawString(nom, (int)(x+0.5) - 5 - fm.stringWidth(nom), (int)(y+0.5) - 5);
	    break;
	case 4:// N
	    g.drawString(nom, (int)(x+0.5) - (int)(fm.stringWidth(nom) /2), (int)(y+0.5) - 5);
	    break;
	case 5:// NE
	    g.drawString(nom, (int)(x+0.5) + 5, (int)(y+0.5) - 5);
	    break;
	case 6:// E
	    g.drawString(nom, (int)(x+0.5) + 5, (int)(y+0.5) + ((int)fm.getAscent() / 2));
	    break;
	case 7:// SE
	    g.drawString(nom, (int)(x+0.5) + 5, (int)(y+0.5) + 5 + fm.getAscent());
	    break;
	case 8:// S
	    g.drawString(nom, (int)(x+0.5) - (int)(fm.stringWidth(nom) /2), (int)(y+0.5) + 5 + fm.getAscent());
	    break;
	case 9:// SW
	    g.drawString(nom, (int)(x+0.5) - 5 - fm.stringWidth(nom), (int)(y+0.5) + 5 + fm.getAscent());
	    break;
	}
    }
    // est-ce utile ?
    // oui, pour les prototypes
    int copie(GeoPlanJObjet obj) { // faut-il ajouter un booleen pour copier aussi la couleur, ...
	if(obj.type == GeoPlanJObjet.Point) {
	    this.x = ((GeoPlanJPoint)obj).x;
	    this.y = ((GeoPlanJPoint)obj).y;
	    return(0);
	} else {
	    System.out.println("Erreur : tentative de copier un objet de mauvais type");
	    return(-1);
	}
    }
}
