import java.awt.Graphics;
import java.awt.Color;

class GeoPlanJPolygone extends GeoPlanJObjetDessinable {
    public static final int PolygoneParSommets = 1;
    public static final int PolygoneRegulier = 2;
    public static final int RectangleDiagonale = 3;
    public static final int RectangleNumerique = 4;
    int[] x;
    int[] y;
    boolean tiret;
    GeoPlanJPolygone(String nom, GeoPlanJObjet[] antecedents, int sousType, int param, GeoPlanJFigure figure, int numeroEcran) {
	this.numeroEcran = numeroEcran;
	this.nom = nom;
	this.type = GeoPlanJObjet.Polygone;
	this.antecedents = antecedents;
	this.sousType = sousType;
	this.param = param;
	this.figure = figure;
	this.couleur = Color.black;
    }
    void particularitesParDefaut() {
	couleur = Color.black;
	epaisseur = 1;
	tiret = false;
    }
    void particularite(String texte) {
	Color tempColor = figure.couleurNommee(texte);
	if(tempColor != null) {
	    couleur = tempColor;
	} else if("rempli avec la couleur du bord".equals(texte)) {
	    epaisseur = 3;
	} else if("dessin".equals(texte)) {
	    epaisseur = 1;
	} else if("non dessin".equals(texte)) {
	    epaisseur = 0;
	} else if("tiret".equals(texte)) {
	    tiret = true;
	} else if("trait pais".equals(texte)) {
	    epaisseur = 2;
	} else {
	    System.out.println("particularite " + texte + " est inconnue, donc ignoree");
	}
    }
    void dessine() {
	if(!HS) {
	    figure.offgraph[numeroEcran].setColor(couleur);
	    switch(epaisseur) {
	    case 3:// rempli
		figure.offgraph[numeroEcran * figure.traceActive].fillPolygon(x, y, x.length);
		break;
	    case 2:
		//pas de break
	    case 1:
		GeoPlanJDroite.dessineSegment(figure.offgraph[numeroEcran * figure.traceActive], x[0], y[0], x[x.length - 1], y[x.length - 1], epaisseur, tiret, couleur);
		for(int i = 1 ; i < x.length ; i++) {
		    GeoPlanJDroite.dessineSegment(figure.offgraph[numeroEcran * figure.traceActive], x[i-1], y[i-1], x[i], y[i], epaisseur, tiret, couleur);
		}
		break;
	    }
	}
    }
    void miseAJour() {
	for(int i = 0 ; i < antecedents.length ; i++) {
	    if(antecedents[i].HS) {
		this.HS = true;
		return;
	    }
	}
	switch(sousType) {
	case Normal:
	    switch(param) {
	    case PolygoneParSommets:
		if(x == null) {
		    x = new int[antecedents.length];
		    y = new int[antecedents.length];
		}
		for(int i = 0 ; i < antecedents.length ; i++) {
		    x[i] = (int)(((GeoPlanJPoint)antecedents[i]).x + 0.5);
		    y[i] = (int)(((GeoPlanJPoint)antecedents[i]).y + 0.5);
		}
		break;
	    case PolygoneRegulier:
		int n = (int)(((GeoPlanJNombre)antecedents[0]).valeur + 0.5);
		if(x == null || x.length != n) {
		    x = new int[n];
		    y = new int[n];
		}
		x[0] = (int)(((GeoPlanJPoint)antecedents[2]).x + 0.5);
		y[0] = (int)(((GeoPlanJPoint)antecedents[2]).y + 0.5);
		double vecx = ((GeoPlanJPoint)antecedents[2]).x - ((GeoPlanJPoint)antecedents[1]).x;
		double vecy = ((GeoPlanJPoint)antecedents[2]).y - ((GeoPlanJPoint)antecedents[1]).y;
		double dteta = 2*Math.PI / n;
		double teta = dteta;
		for(int i = 1 ; i < n ; i++) {
		    double cost = Math.cos(teta);
		    double sint = Math.sin(teta);
		    x[i] = (int)(((GeoPlanJPoint)antecedents[1]).x + vecx * cost - vecy * sint + 0.5);
		    y[i] = (int)(((GeoPlanJPoint)antecedents[1]).y + vecx * sint + vecy * cost + 0.5);
		    teta += dteta;
		}
		break;
	    default:
		System.out.println("Erreur : type de " + this.nom + " non prvu");
		HS = true;
		break;
	    }
	    break;
	default:
	    // cas des prototypes
	    GeoPlanJObjet proto = miseAJourPrototype();
	    if(proto == null) {
		HS = true;
		//System.out.println("HS");
		return;
	    }
	    this.x = new int[((GeoPlanJPolygone)proto).x.length];
	    System.arraycopy(((GeoPlanJPolygone)proto).x, 0, this.x, 0, this.x.length);
	    this.y = new int[((GeoPlanJPolygone)proto).y.length];
	    System.arraycopy(((GeoPlanJPolygone)proto).y, 0, this.y, 0, this.y.length);
	    HS = false;
	    break;
	}
    }
    int copie(GeoPlanJObjet obj) {
	if(obj.type == GeoPlanJObjet.Polygone) {
	    this.x = new int[((GeoPlanJPolygone)obj).x.length];
	    System.arraycopy(((GeoPlanJPolygone)obj).x, 0, this.x, 0, this.x.length);
	    this.y = new int[((GeoPlanJPolygone)obj).y.length];
	    System.arraycopy(((GeoPlanJPolygone)obj).y, 0, this.y, 0, this.y.length);
	    return(0);
	} else {
	    System.out.println("Erreur : tentative de copier un objet de mauvais type");
	    return(-1);
	}
    }
}
