import java.awt.Graphics;

class GeoPlanJTransform extends GeoPlanJObjet {
    public static final int Composee = 0;
    public static final int SymetrieAxiale = 1;
    public static final int SymetrieCentrale = 2;
    public static final int Homothetie = 3;
    public static final int Rotation = 4;
    public static final int ProjectionOrthogonale = 5;
    public static final int ProjectionOblique = 6;
    public static final int Translation = 7;
    public static final int Similitude = 8;
    //int sousType;
    //GeoPlanJObjet objet1, objet2;
    double ax, bx, cx;// pour x'= ax*x + bx*y + cx
    double ay, by, cy;// pour y'= ay*x + by*y + cy
    /*
    GeoPlanJTransform(String name, GeoPlanJObjet A, int sType)
    {
	type = GeoPlanJObjet.Transform;
	sousType = sType;
	nom = name;
	objet1 = A;
	objet2 = null;
    }
    GeoPlanJTransform(String name, GeoPlanJObjet A, GeoPlanJObjet B, int sType)
    {
	type = GeoPlanJObjet.Transform;
	sousType = sType;
	nom = name;
	objet1 = A;
	objet2 = B;
    }
    */
    GeoPlanJTransform(String nom, GeoPlanJObjet[] antecedents, int sousType, int param, GeoPlanJFigure figure) {
	this.nom = nom;
	this.type = GeoPlanJObjet.Transform;
	this.antecedents = antecedents;
	this.sousType = sousType;
	this.param = param;
	this.figure = figure;
    }
    void miseAJour() {
	for(int i = 0 ; i < antecedents.length ; i++) {
	    if(antecedents[i].HS) {
		this.HS = true;
		return;
	    }
	}
	switch(sousType) {
	default:
	    //cas des Prototypes
	    GeoPlanJObjet proto = miseAJourPrototype();
	    if(proto == null) {
		HS = true;
		return;
	    } else {
		this.ax = ((GeoPlanJTransform)proto).ax;
		this.bx = ((GeoPlanJTransform)proto).bx;
		this.cx = ((GeoPlanJTransform)proto).cx;
		this.ay = ((GeoPlanJTransform)proto).ay;
		this.by = ((GeoPlanJTransform)proto).by;
		this.cy = ((GeoPlanJTransform)proto).cy;
		HS = false;
		return;
	    }
	case Normal:
	    HS = false;
	    switch(param) {
	    case Composee:
		ax = ((GeoPlanJTransform)antecedents[0]).ax * ((GeoPlanJTransform)antecedents[1]).ax +((GeoPlanJTransform)antecedents[0]).ay * ((GeoPlanJTransform)antecedents[1]).bx;
		bx = ((GeoPlanJTransform)antecedents[0]).bx * ((GeoPlanJTransform)antecedents[1]).ax +((GeoPlanJTransform)antecedents[0]).by * ((GeoPlanJTransform)antecedents[1]).bx;
		cx = ((GeoPlanJTransform)antecedents[0]).cx * ((GeoPlanJTransform)antecedents[1]).ax +((GeoPlanJTransform)antecedents[0]).cy * ((GeoPlanJTransform)antecedents[1]).bx +((GeoPlanJTransform)antecedents[1]).cx;
		ay = ((GeoPlanJTransform)antecedents[0]).ax * ((GeoPlanJTransform)antecedents[1]).ay +((GeoPlanJTransform)antecedents[0]).ay * ((GeoPlanJTransform)antecedents[1]).by;
		by = ((GeoPlanJTransform)antecedents[0]).bx * ((GeoPlanJTransform)antecedents[1]).ay +((GeoPlanJTransform)antecedents[0]).by * ((GeoPlanJTransform)antecedents[1]).by;
		cy = ((GeoPlanJTransform)antecedents[0]).cx * ((GeoPlanJTransform)antecedents[1]).ay +((GeoPlanJTransform)antecedents[0]).cy * ((GeoPlanJTransform)antecedents[1]).by +((GeoPlanJTransform)antecedents[1]).cy;
		break;
	    case SymetrieAxiale:
		double a = ((GeoPlanJDroite)antecedents[0]).y0 - ((GeoPlanJDroite)antecedents[0]).y1;
		double b = ((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0;
		double c = ((GeoPlanJDroite)antecedents[0]).x0 * ((GeoPlanJDroite)antecedents[0]).y1 - ((GeoPlanJDroite)antecedents[0]).x1 * ((GeoPlanJDroite)antecedents[0]).y0;
		double den = a * a + b * b;
		ax = 1 - 2 * a * a / den;
		bx = -2 * b * a / den;
		cx = -2 * c * a / den;
		ay = -2 * a * b / den;
		by = 1 - 2 * b * b / den;
		cy = -2 * c * b / den;
		break;
	    case SymetrieCentrale:
		//dois-je eliminer cette symetrie,
		//au profit d'une homothetie de rapport -1 ?
		ax = -1;
		bx = 0;
		cx = 2*((GeoPlanJPoint)antecedents[0]).x;
		ay = 0;
		by = -1;
		cy = 2*((GeoPlanJPoint)antecedents[0]).y;
		break;
	    case Homothetie:
		switch(antecedents.length) {
		case 2:
		    ax = ((GeoPlanJNombre)antecedents[1]).valeur;
		    bx = 0;
		    cx = (1 - ((GeoPlanJNombre)antecedents[1]).valeur) * ((GeoPlanJPoint)antecedents[0]).x;
		    ay = 0;
		    by = ((GeoPlanJNombre)antecedents[1]).valeur;
		    cy = (1 - ((GeoPlanJNombre)antecedents[1]).valeur) * ((GeoPlanJPoint)antecedents[0]).y;
		    break;
		case 3:// homothetie de centre P, transformant P en P
		    double dx1 = ((GeoPlanJPoint)antecedents[1]).x - ((GeoPlanJPoint)antecedents[0]).x;
		    double dy1 = ((GeoPlanJPoint)antecedents[1]).y - ((GeoPlanJPoint)antecedents[0]).y;
		    double dx2 = ((GeoPlanJPoint)antecedents[2]).x - ((GeoPlanJPoint)antecedents[0]).x;
		    double dy2 = ((GeoPlanJPoint)antecedents[2]).y - ((GeoPlanJPoint)antecedents[0]).y;
		    double lambda;
		    if(Math.abs(dx1) < 0.00001) {
			if(Math.abs(dx2) < 0.00001) {
			    if(Math.abs(dy1) < 0.00001) {
				HS = true;
				return;
			    } else {
				lambda = dy2 / dy1;
			    }
			} else {
			    HS = true;
			    return;
			}
		    } else {
			lambda = dx2 / dx1;
			if(Math.abs(dy1 * lambda - dy2) > 0.00001) {
			    HS = true;
			    return;
			}
		    }
		    ax = lambda;
		    bx = 0;
		    cx = (1 - lambda) * ((GeoPlanJPoint)antecedents[0]).x;
		    ay = 0;
		    by = lambda;
		    cy = (1 - lambda) * ((GeoPlanJPoint)antecedents[0]).y;
		    break;
		default:
		    System.out.println("nombre d'antecedents de l'homothetie " + nom + " non prevu");
		    HS = true;
		}
		break;
	    case Rotation:
		double costheta = Math.cos(((GeoPlanJNombre)antecedents[1]).valeur);
		double sintheta = Math.sin(((GeoPlanJNombre)antecedents[1]).valeur);
		ax = costheta;
		bx = sintheta;
		cx = (1 - costheta) * ((GeoPlanJPoint)antecedents[0]).x
		    - sintheta * ((GeoPlanJPoint)antecedents[0]).y;
		ay = -sintheta;
		by = costheta;
		cy = sintheta * ((GeoPlanJPoint)antecedents[0]).x
		    + (1 - costheta) * ((GeoPlanJPoint)antecedents[0]).y;
		break;
	    case ProjectionOrthogonale:
		a = ((GeoPlanJDroite)antecedents[0]).y0 - ((GeoPlanJDroite)antecedents[0]).y1;
		b = ((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0;
		c = ((GeoPlanJDroite)antecedents[0]).x0 * ((GeoPlanJDroite)antecedents[0]).y1 - ((GeoPlanJDroite)antecedents[0]).x1 * ((GeoPlanJDroite)antecedents[0]).y0;
		den = a * a + b * b;
		ax = b * b / den;
		bx = -b * a / den;
		cx = -c * a / den;
		ay = -a * b / den;
		by = a * a / den;
		cy = -c * b / den;
		break;
	    case ProjectionOblique:// a faire
		a = ((GeoPlanJDroite)antecedents[0]).y0 - ((GeoPlanJDroite)antecedents[0]).y1;
		b = ((GeoPlanJDroite)antecedents[0]).x1 - ((GeoPlanJDroite)antecedents[0]).x0;
		c = ((GeoPlanJDroite)antecedents[0]).x0 * ((GeoPlanJDroite)antecedents[0]).y1 - ((GeoPlanJDroite)antecedents[0]).x1 * ((GeoPlanJDroite)antecedents[0]).y0;
		double a2 = ((GeoPlanJDroite)antecedents[1]).y0 - ((GeoPlanJDroite)antecedents[1]).y1;
		double b2 = ((GeoPlanJDroite)antecedents[1]).x1 - ((GeoPlanJDroite)antecedents[1]).x0;
		double c2 = ((GeoPlanJDroite)antecedents[1]).x0 * ((GeoPlanJDroite)antecedents[1]).y1 - ((GeoPlanJDroite)antecedents[1]).x1 * ((GeoPlanJDroite)antecedents[1]).y0;
		/*
M(X,Y)
soit M'(X',Y') sur d
donc, a X' + b Y'= -c
et    a'X' + b'Y' = a'X + b'Y

X' = (-cb' -b(a'X+b'Y)) / (ab' - ba')
Y' = (a(a'X+b'Y) + ca') / (ab' - ba')
		*/
		den = a * b2 - b * a2;
		ax = - b * a2 / den;
		bx = - b * b2 / den;
		cx = - c * b2 / den;
		ay = a * a2 / den;
		by = a * b2 / den;
		cy = c * a2 / den;
		break;
	    case Translation:
		// tester s'il s'agit d'un vecteur ou de deux points
		switch(antecedents.length) {
		case 1:
		    if(antecedents[0].type != GeoPlanJObjet.Vecteur) {
			HS = true;
			return;
		    }
		    ax = 1;
		    bx = 0;
		    cx = ((GeoPlanJVecteur)antecedents[0]).x;
		    ay = 0;
		    by = 1;
		    cy = ((GeoPlanJVecteur)antecedents[0]).y;
		    break;
		case 2:
		    if(antecedents[0].type != GeoPlanJObjet.Point && antecedents[1].type != GeoPlanJObjet.Point) {
			HS = true;
			return;
		    }
		    ax = 1;
		    bx = 0;
		    cx = ((GeoPlanJPoint)antecedents[1]).x - ((GeoPlanJPoint)antecedents[0]).x;
		    ay = 0;
		    by = 1;
		    cy = ((GeoPlanJPoint)antecedents[1]).y - ((GeoPlanJPoint)antecedents[0]).y;
		    break;
		default:
		    System.out.println("erreur dans le nombre d'antecedents de la translation " + nom);
		    HS = true;
		    return;
		}
		break;
	    case Similitude://a faire
		if(antecedents.length != 3) {
		    System.out.println("le nombre d'antecedents de la similitude " + nom + " est " + antecedents.length + ", il devrait etre de 3");
		    HS = true;
		    return;
		}
		switch(antecedents[0].type) {
		case GeoPlanJObjet.Point:
		    switch(antecedents[1].type) {
		    case GeoPlanJObjet.Nombre:
			switch(antecedents[2].type) {
			case GeoPlanJObjet.Nombre:
			    /*
			      X' = (X-x) * cos(alpha) * lambda + (Y-y) * sin(alpha) * lambda + x
			      Y' = - (X-x) * sin(alpha) * lambda + (Y-y) * cos(alpha) * lambda + y
			     */
			    costheta = Math.cos(((GeoPlanJNombre)antecedents[1]).valeur) * ((GeoPlanJNombre)antecedents[2]).valeur;
			    sintheta = Math.sin(((GeoPlanJNombre)antecedents[1]).valeur) * ((GeoPlanJNombre)antecedents[2]).valeur;
			    ax = costheta;
			    bx = sintheta;
			    cx = (1 - costheta) * ((GeoPlanJPoint)antecedents[0]).x
				- sintheta * ((GeoPlanJPoint)antecedents[0]).y;
			    ay = -sintheta;
			    by = costheta;
			    cy = sintheta * ((GeoPlanJPoint)antecedents[0]).x
				+ (1 - costheta) * ((GeoPlanJPoint)antecedents[0]).y;
			    break;
			default:
			    System.out.println("Erreur : similitude " + nom + ". Antecedents de type Point-Nombre-non Nombre");
			    HS = true;
			}
			break;
		    case GeoPlanJObjet.Point:
			switch(antecedents[2].type) {
			case GeoPlanJObjet.Point:
			    double dx1 = ((GeoPlanJPoint)antecedents[1]).x - ((GeoPlanJPoint)antecedents[0]).x;
			    double dy1 = ((GeoPlanJPoint)antecedents[1]).y - ((GeoPlanJPoint)antecedents[0]).y;
			    double dx2 = ((GeoPlanJPoint)antecedents[2]).x - ((GeoPlanJPoint)antecedents[0]).x;
			    double dy2 = ((GeoPlanJPoint)antecedents[2]).y - ((GeoPlanJPoint)antecedents[0]).y;
/*
lambda = Math.sqrt((dx2^2+dy2^2)/(dx1^2+dy1^2))
angle = Math.atan2(dy1, dx1) - Math.atan2(dy2, dx2); (inversion a cause des coordonnees ecran)
BOF!
Resoudre : (C=?, S=?)
x2 = C * x1 + S y1 + (1 - C) * x0 - S * y0
y2 = - S * x1 + C * y1 + S * x0 + ( 1 - C) * y0
donne
C * (x1 - x0) + S * (y1 - y0) = x2 - x0
C * (y1 - y0) - S * (x1 - x0) = y2 - y0
			     */
			    den = dx1 * dx1 + dy1 * dy1;
			    if(Math.abs(den) < 0.00001) {
				HS = true;
				return;
			    }
			    double C = (dx1 * dx2 + dy1 * dy2) / den;
			    double S = (dy1 * dx2 - dx1 * dy2) / den;
			    ax = C;
			    bx = S;
			    cx = (1 - C) * ((GeoPlanJPoint)antecedents[0]).x
				- S * ((GeoPlanJPoint)antecedents[0]).y;
			    ay = -S;
			    by = C;
			    cy = S * ((GeoPlanJPoint)antecedents[0]).x
				+ (1 - C) * ((GeoPlanJPoint)antecedents[0]).y;
			    break;
			default:
			    System.out.println("Erreur : similitude " + nom + ". Antecedents de type Point-Point-non Point");
			    HS = true;
			}
			break;
		    default:
			System.out.println("Erreur : similitude " + nom + ". Le deuxieme antecedent n'est ni un nombre, ni un point");
			HS = true;
		    }
		    break;
		default:
		    System.out.println("Erreur : similitude " + nom + ". Le premier antecedent n'est pas un point");
		    HS = true;
		}
		break;
	    default:
		System.out.println("Erreur : type de param inconnu dans " + this.nom);
		HS = true;
	    }
	    break;
	}
    }
    int copie(GeoPlanJObjet obj) { // faut-il ajouter un booleen pour copier aussi la couleur, ...
	if(obj.type == GeoPlanJObjet.Transform) {
	    this.ax = ((GeoPlanJTransform)obj).ax;
	    this.bx = ((GeoPlanJTransform)obj).bx;
	    this.cx = ((GeoPlanJTransform)obj).cx;
	    this.ay = ((GeoPlanJTransform)obj).ay;
	    this.by = ((GeoPlanJTransform)obj).by;
	    this.cy = ((GeoPlanJTransform)obj).cy;
	    return(0);
	} else {
	    System.out.println("Erreur : tentative de copier un objet de mauvais type");
	    return(-1);
	}
    }
}
