import java.awt.Graphics;
import java.awt.Color;
import java.lang.Math;

class GeoPlanJVecteur extends GeoPlanJObjet {
    public static final int Numerique = 0;
    public static final int Bipoint = 1;
    public static final int Addition = 2;
    public static final int Soustraction = 3;
    public static final int Multiplication = 4;
    public static final int Transformation = 5;
    public static final int Division = 6;
    public static final int Puissance = 7;
    public static final int Repere = 8;

    double x, y;

    GeoPlanJVecteur(String nom, GeoPlanJObjet[] antecedents, int sousType, int param, GeoPlanJFigure figure) {
	this.nom = nom;
	this.type = GeoPlanJObjet.Vecteur;
	this.antecedents = antecedents;
	this.sousType = sousType;
	this.param = param;
	this.figure = figure;
    }
    GeoPlanJObjet addition(GeoPlanJObjet x, GeoPlanJFigure figure) {
	if(x == null || x.type != GeoPlanJObjet.Vecteur) {
	    return(null);
	}
	String n = nom + "+" + x.nom;
	GeoPlanJObjet y = figure.objetNomme(n);
	if(y == null) {
	    GeoPlanJObjet[] tempAntecedents = new GeoPlanJObjet[2];
	    tempAntecedents[0] = this;
	    tempAntecedents[1] = x;
	    y = new GeoPlanJVecteur(n, tempAntecedents, Normal, Addition, this.figure);
	    figure.ajouteObjet(y);
	} else if(y.type != GeoPlanJObjet.Vecteur) {
	    System.out.println("l'objet existe dj, mais n'est pas un vecteur");
	    return(null);
	}
	return(y);
    }
    GeoPlanJObjet soustraction(GeoPlanJObjet x, GeoPlanJFigure figure) {
	if(x == null || x.type != GeoPlanJObjet.Vecteur) {
	    return(null);
	}
	String n = nom + "-" + x.nom;
	GeoPlanJObjet y = figure.objetNomme(n);
	if(y == null) {
	    GeoPlanJObjet[] tempAntecedents = new GeoPlanJObjet[2];
	    tempAntecedents[0] = this;
	    tempAntecedents[1] = x;
	    y = new GeoPlanJVecteur(n, tempAntecedents, Normal, Soustraction, this.figure);
	    figure.ajouteObjet(y);
	} else if(y.type != GeoPlanJObjet.Vecteur) {
	    System.out.println("l'objet existe dj, mais n'est pas un vecteur");
	    return(null);
	}
	return(y);
    }
    GeoPlanJObjet multiplication(GeoPlanJObjet x, GeoPlanJFigure figure) {
	if(x == null) {
	    return(null);
	}
	if(x.type == GeoPlanJObjet.Nombre) {
	    String n = x.nom + "*" + nom;
	    GeoPlanJObjet y = figure.objetNomme(n);
	    if(y == null) {
		GeoPlanJObjet[] tempAntecedents = new GeoPlanJObjet[2];
		tempAntecedents[0] = this;
		tempAntecedents[1] = x;
		y = new GeoPlanJVecteur(n, tempAntecedents, Normal, Addition, this.figure);
		figure.ajouteObjet(y);
	    } else if(y.type != GeoPlanJObjet.Vecteur) {
		System.out.println("l'objet existe dj, mais n'est pas un vecteur");
		return(null);
	    }
	    return(y);
	} else if(x.type == GeoPlanJObjet.Vecteur) {
	    String n = nom + "&" + x.nom;
	    GeoPlanJObjet y = figure.objetNomme(n);
	    if(y == null) {
		GeoPlanJObjet[] tempAntecedents = new GeoPlanJObjet[2];
		tempAntecedents[0] = this;
		tempAntecedents[1] = x;
		y = new GeoPlanJNombre(n, tempAntecedents, GeoPlanJNombre.Normal, Multiplication, this.figure);
		figure.ajouteObjet(y);
	    } else if(y.type != GeoPlanJObjet.Nombre) {
		System.out.println("l'objet existe dj, mais n'est pas un nombre");
		return(null);
	    }
	    return(y);
	} else {
	    return(null);
	}
    }
    GeoPlanJObjet division(GeoPlanJObjet x, GeoPlanJFigure figure) {
	if(x == null || x.type != GeoPlanJObjet.Nombre) {
	    return(null);
	}
	String n = nom + "/" + x.nom;
	GeoPlanJObjet y = figure.objetNomme(n);
	if(y == null) {
	    GeoPlanJObjet[] tempAntecedents = new GeoPlanJObjet[2];
	    tempAntecedents[0] = this;
	    tempAntecedents[1] = x;
	    y = new GeoPlanJVecteur(n, tempAntecedents, Normal, Division, this.figure);
	    figure.ajouteObjet(y);
	} else if(y.type != GeoPlanJObjet.Vecteur) {
	    System.out.println("l'objet existe dj, mais n'est pas un vecteur");
	    return(null);
	}
	return(y);
    }
    void miseAJour() {
	for(int i = 0 ; i < antecedents.length ; i++) {
	    if(antecedents[i].HS) {
		this.HS = true;
		return;
	    }
	}
	switch(sousType) {
	default:
	    //cas des Prototypes
	    GeoPlanJObjet proto = miseAJourPrototype();
	    if(proto == null) {
		HS = true;
		return;
	    }
	    if(copie(proto) == 0) {
		HS = false;
		return;
	    } else {
		System.out.println("BUG!!! le type de l'objet " + this.nom + " et de son prototype ne correspondent pas");
		HS = true;
		return;
	    }
	case Normal:
	    switch(antecedents.length) {
	    case 2:
		switch(param) {
		case Numerique:
		    x = ((GeoPlanJNombre)antecedents[0]).valeur;
		    y = ((GeoPlanJNombre)antecedents[1]).valeur;
		    HS = false;
		    return;
		case Bipoint:
		    x = ((GeoPlanJPoint)antecedents[1]).x - ((GeoPlanJPoint)antecedents[0]).x;
		    y = ((GeoPlanJPoint)antecedents[1]).y - ((GeoPlanJPoint)antecedents[0]).y;
		    HS = false;
		    return;
		case Addition:
		    x = ((GeoPlanJVecteur)antecedents[0]).x + ((GeoPlanJVecteur)antecedents[1]).x;
		    y = ((GeoPlanJVecteur)antecedents[0]).y + ((GeoPlanJVecteur)antecedents[1]).y;
		    HS = false;
		    return;
		case Soustraction:
		    x = ((GeoPlanJVecteur)antecedents[0]).x - ((GeoPlanJVecteur)antecedents[1]).x;
		    y = ((GeoPlanJVecteur)antecedents[0]).y - ((GeoPlanJVecteur)antecedents[1]).y;
		    HS = false;
		    return;
		case Multiplication://antecedents[0] est un nombre, antecedents[1] est un vecteur
		    //pas de produit vectoriel dans le plan
		    //et le produit scalaire est un GeoPlanJNombre, pas un GeoPlanJVecteur
		    x = ((GeoPlanJNombre)antecedents[0]).valeur * ((GeoPlanJVecteur)antecedents[1]).x;
		    y = ((GeoPlanJNombre)antecedents[0]).valeur * ((GeoPlanJVecteur)antecedents[1]).y;
		    HS = false;
		    return;
		case Transformation://antecedents[0] est une transformation
		    //antecedents[1] est un vecteur
		    x = ((GeoPlanJTransform)antecedents[0]).ax * ((GeoPlanJVecteur)antecedents[1]).x +
			((GeoPlanJTransform)antecedents[0]).bx * ((GeoPlanJVecteur)antecedents[1]).y;
		    y = ((GeoPlanJTransform)antecedents[0]).ay * ((GeoPlanJVecteur)antecedents[1]).x +
			((GeoPlanJTransform)antecedents[0]).by * ((GeoPlanJVecteur)antecedents[1]).y;
		    return;
		default:
		    System.out.println("ERREUR!!! param de " + this.nom + " non prvu");
		    HS = true;
		    return;
		}
	    case 3:
		switch(antecedents[0].type) {
		case GeoPlanJObjet.Nombre:
		    switch(antecedents[1].type) {
		    case GeoPlanJObjet.Nombre:
			switch(antecedents[2].type) {
			case GeoPlanJObjet.Repere:
			    x = ((GeoPlanJRepere)antecedents[2]).ax * ((GeoPlanJNombre)antecedents[0]).valeur + ((GeoPlanJRepere)antecedents[2]).bx * ((GeoPlanJNombre)antecedents[1]).valeur;
			    y = ((GeoPlanJRepere)antecedents[2]).ay * ((GeoPlanJNombre)antecedents[0]).valeur + ((GeoPlanJRepere)antecedents[2]).by * ((GeoPlanJNombre)antecedents[1]).valeur;
			    break;
			default:
			    System.out.println("Vecteur avec 3 antcdents : type antcdent3 non prvu");
			    HS = true;
			}
			break;
		    default:
			System.out.println("Vecteur avec 3 antcdents : type antcdent2 non prvu");
			HS = true;
		    }
		    break;
		default:
		    System.out.println("Vecteur avec 3 antcdents : type antcdent1 non prvu");
		    HS = true;
		}
		break;
	    default:
		System.out.println("ERREUR!!! nombre d'antcdents de " + this.nom + " non prvu");
		HS = true;
		return;
	    }
	}
    }
    int copie(GeoPlanJObjet obj) { // faut-il ajouter un booleen pour copier aussi la couleur, ...
	if(obj.type == GeoPlanJObjet.Vecteur) {
	    this.x = ((GeoPlanJVecteur)obj).x;
	    this.y = ((GeoPlanJVecteur)obj).y;
	    return(0);
	} else {
	    System.out.println("Erreur : tentative de copier un objet de mauvais type");
	    return(-1);
	}
    }
}




